/*
 * Decompiled with CFR 0.152.
 */
package org.jheaps.array;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import org.jheaps.AddressableHeap;
import org.jheaps.annotations.LinearTime;
import org.jheaps.array.AbstractArrayAddressableHeap;

public class DaryArrayAddressableHeap<K, V>
extends AbstractArrayAddressableHeap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_HEAP_CAPACITY = 16;
    protected int d;

    public DaryArrayAddressableHeap(int d2) {
        this(d2, null, 16);
    }

    public DaryArrayAddressableHeap(int d2, int capacity) {
        this(d2, null, capacity);
    }

    public DaryArrayAddressableHeap(int d2, Comparator<? super K> comparator) {
        this(d2, comparator, 16);
    }

    public DaryArrayAddressableHeap(int d2, Comparator<? super K> comparator, int capacity) {
        super(comparator, capacity);
        if (d2 < 2) {
            throw new IllegalArgumentException("D-ary heaps must have at least 2 children per node");
        }
        this.d = d2;
    }

    @LinearTime
    public static <K, V> DaryArrayAddressableHeap<K, V> heapify(int d2, K[] keys, V[] values) {
        int i;
        if (d2 < 2) {
            throw new IllegalArgumentException("D-ary heaps must have at least 2 children per node");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Key array cannot be null");
        }
        if (values != null && keys.length != values.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys.length == 0) {
            return new DaryArrayAddressableHeap<K, V>(d2);
        }
        DaryArrayAddressableHeap<K, V> h2 = new DaryArrayAddressableHeap<K, V>(d2, keys.length);
        for (i = 0; i < keys.length; ++i) {
            K key = keys[i];
            Object value = values == null ? null : (Object)values[i];
            DaryArrayAddressableHeap<K, V> daryArrayAddressableHeap = h2;
            daryArrayAddressableHeap.getClass();
            AbstractArrayAddressableHeap.ArrayHandle ah = daryArrayAddressableHeap.new AbstractArrayAddressableHeap.ArrayHandle(key, value);
            ah.index = i + 1;
            h2.array[i + 1] = ah;
        }
        h2.size = keys.length;
        for (i = keys.length / d2; i > 0; --i) {
            h2.fixdown(i);
        }
        return h2;
    }

    @LinearTime
    public static <K, V> DaryArrayAddressableHeap<K, V> heapify(int d2, K[] keys, V[] values, Comparator<? super K> comparator) {
        int i;
        if (d2 < 2) {
            throw new IllegalArgumentException("D-ary heaps must have at least 2 children per node");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Keys array cannot be null");
        }
        if (values != null && keys.length != values.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys.length == 0) {
            return new DaryArrayAddressableHeap<K, V>(d2, comparator);
        }
        DaryArrayAddressableHeap<K, V> h2 = new DaryArrayAddressableHeap<K, V>(d2, comparator, keys.length);
        for (i = 0; i < keys.length; ++i) {
            K key = keys[i];
            Object value = values == null ? null : (Object)values[i];
            DaryArrayAddressableHeap<K, V> daryArrayAddressableHeap = h2;
            daryArrayAddressableHeap.getClass();
            AbstractArrayAddressableHeap.ArrayHandle ah = daryArrayAddressableHeap.new AbstractArrayAddressableHeap.ArrayHandle(key, value);
            ah.index = i + 1;
            h2.array[i + 1] = ah;
        }
        h2.size = keys.length;
        for (i = keys.length / d2; i > 0; --i) {
            h2.fixdownWithComparator(i);
        }
        return h2;
    }

    public Iterator<AddressableHeap.Handle<K, V>> handlesIterator() {
        return new Iterator<AddressableHeap.Handle<K, V>>(){
            private int pos = 1;

            @Override
            public boolean hasNext() {
                return this.pos <= DaryArrayAddressableHeap.this.size;
            }

            @Override
            public AddressableHeap.Handle<K, V> next() {
                return DaryArrayAddressableHeap.this.array[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void ensureCapacity(int capacity) {
        this.checkCapacity(capacity);
        AbstractArrayAddressableHeap.ArrayHandle[] newArray = (AbstractArrayAddressableHeap.ArrayHandle[])Array.newInstance(AbstractArrayAddressableHeap.ArrayHandle.class, capacity + 1);
        System.arraycopy(this.array, 1, newArray, 1, this.size);
        this.array = newArray;
    }

    @Override
    protected void forceFixup(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (k > 1) {
            int p = (k - 2) / this.d + 1;
            this.array[k] = this.array[p];
            this.array[k].index = k;
            k = p;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixup(int k) {
        int p;
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (k > 1 && ((Comparable)this.array[p = (k - 2) / this.d + 1].getKey()).compareTo(h2.getKey()) > 0) {
            this.array[k] = this.array[p];
            this.array[k].index = k;
            k = p;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixupWithComparator(int k) {
        int p;
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while (k > 1 && this.comparator.compare(this.array[p = (k - 2) / this.d + 1].getKey(), h2.getKey()) > 0) {
            this.array[k] = this.array[p];
            this.array[k].index = k;
            k = p;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixdown(int k) {
        int c2;
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while ((c2 = this.d * (k - 1) + 2) <= this.size) {
            int maxc = c2;
            for (int i = 1; i < this.d && c2 + i <= this.size; ++i) {
                if (((Comparable)this.array[maxc].getKey()).compareTo(this.array[c2 + i].getKey()) <= 0) continue;
                maxc = c2 + i;
            }
            if (((Comparable)h2.getKey()).compareTo(this.array[maxc].getKey()) <= 0) break;
            this.array[k] = this.array[maxc];
            this.array[k].index = k;
            k = maxc;
        }
        this.array[k] = h2;
        h2.index = k;
    }

    @Override
    protected void fixdownWithComparator(int k) {
        int c2;
        AbstractArrayAddressableHeap.ArrayHandle h2 = this.array[k];
        while ((c2 = this.d * (k - 1) + 2) <= this.size) {
            int maxc = c2;
            for (int i = 1; i < this.d && c2 + i <= this.size; ++i) {
                if (this.comparator.compare(this.array[maxc].getKey(), this.array[c2 + i].getKey()) <= 0) continue;
                maxc = c2 + i;
            }
            if (this.comparator.compare(h2.getKey(), this.array[maxc].getKey()) <= 0) break;
            this.array[k] = this.array[maxc];
            this.array[k].index = k;
            k = maxc;
        }
        this.array[k] = h2;
        h2.index = k;
    }
}

