/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.util.ArrayList;
import org.vikamine.kernel.data.discretization.AbstractDiscretizationMethod;
import org.vikamine.kernel.data.discretization.ChiMergeDiscretizer;
import org.vikamine.kernel.data.discretization.DiscretizationMethod;
import org.vikamine.kernel.data.discretization.EntropyDiscretizer;
import org.vikamine.kernel.data.discretization.FayyadIraniDiscretizer;
import org.vikamine.kernel.data.discretization.KMeansDiscretizer;
import org.vikamine.kernel.data.discretization.SoftMetaDiscretizer;
import org.vikamine.kernel.data.discretization.The345RuleDiscretizer;
import org.vikamine.kernel.data.discretization.ZetaDiscretizer;
import org.vikamine.kernel.xpdl.MValue;

public class MAttribute {
    private static final String ENTROPY = "entropy";
    private static final String FAYYAD = "fayyad";
    private static final String CHIMERGE = "chimerge";
    private static final String KMEANS = "k-means";
    private static final String THE345RULE = "3-4-5-rule";
    private static final String ZETA = "zeta";
    private static final String SOFTEN = "soften";
    private ArrayList<MValue> values = new ArrayList();
    private final String name;
    private DiscretizationMethod discretizationMethod;

    public MAttribute(String name) {
        this.name = name;
    }

    public MAttribute(String name, String discretizationMethod) {
        this.name = name;
        String[] method = discretizationMethod.split(";");
        String[] type = method[0].split("=");
        String method0 = type[0].trim();
        AbstractDiscretizationMethod disMethod = null;
        if (method0.equalsIgnoreCase(FAYYAD)) {
            disMethod = new FayyadIraniDiscretizer();
        } else if (method0.equalsIgnoreCase(CHIMERGE)) {
            disMethod = new ChiMergeDiscretizer(method);
        } else if (method0.equalsIgnoreCase(KMEANS)) {
            disMethod = new KMeansDiscretizer(method);
        } else if (method0.equalsIgnoreCase(THE345RULE)) {
            disMethod = new The345RuleDiscretizer(method);
        } else if (method0.equalsIgnoreCase(ZETA)) {
            disMethod = new ZetaDiscretizer(method);
        } else if (method0.equalsIgnoreCase(ENTROPY)) {
            disMethod = new EntropyDiscretizer(method);
        }
        if (disMethod == null) {
            return;
        }
        this.discretizationMethod = type.length > 1 && type[1].contains(SOFTEN) ? new SoftMetaDiscretizer(method, disMethod) : disMethod;
    }

    public void addValue(MValue value) {
        this.values.add(value);
    }

    public ArrayList<MValue> getValues() {
        return this.values;
    }

    public void setValues(ArrayList<MValue> values) {
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public int valuesCount() {
        return this.values.size();
    }

    public String toString() {
        return "Attribute: " + this.name + " ,Values: " + this.values;
    }

    public void setDiscretizationMethod(DiscretizationMethod discretizationMethod) {
        this.discretizationMethod = discretizationMethod;
    }

    public boolean hasDiscretizationMethod() {
        return this.discretizationMethod != null;
    }

    public DiscretizationMethod getDiscretizationMethod() {
        return this.discretizationMethod;
    }
}

