/*
 * Decompiled with CFR 0.152.
 */
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.outliers.MCOD.ISBIndex;
import moa.clusterers.outliers.MCOD.MCOD;
import moa.clusterers.outliers.MCOD.MicroCluster;
import moa.clusterers.outliers.MyBaseOutlierDetector;

public class StreamMOA_MCOD
extends MCOD {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<Long, Integer> mapper_id = new LinkedHashMap();
    private LinkedHashMap<Integer, MicroCluster> mapper_mc = new LinkedHashMap();
    private int sequence = 1;

    public void Init() {
        super.Init();
        this.bShowProgress = false;
    }

    private int totalNodes() {
        int n = this.getOutliersResult().size();
        for (MicroCluster microCluster : this.setMC) {
            n += microCluster.nodes.size();
        }
        return n;
    }

    public boolean implementsMicroClusterer() {
        return true;
    }

    public Clustering getMicroClusteringResult() {
        Clustering clustering = new Clustering();
        int n = this.totalNodes();
        int n2 = 1;
        for (MicroCluster microCluster : this.mapper_mc.values()) {
            double[] dArray = new double[microCluster.mcc.inst.numValues()];
            for (int i = 0; i < microCluster.mcc.inst.numValues(); ++i) {
                dArray[i] = microCluster.mcc.inst.value(i);
            }
            SphereCluster sphereCluster = new SphereCluster(dArray, this.m_radius, (double)microCluster.nodes.size() / (double)n);
            sphereCluster.setId((double)n2++);
            clustering.add((Cluster)sphereCluster);
        }
        return clustering;
    }

    public Clustering getOutlierClusteringResult() {
        Clustering clustering = new Clustering();
        int n = this.totalNodes();
        for (MyBaseOutlierDetector.Outlier outlier : this.getOutliersResult()) {
            double[] dArray = new double[outlier.inst.numValues()];
            for (int i = 0; i < outlier.inst.numValues(); ++i) {
                dArray[i] = outlier.inst.value(i);
            }
            SphereCluster sphereCluster = new SphereCluster(dArray, this.m_radius, 1.0 / (double)n);
            sphereCluster.setId((double)outlier.id);
            clustering.add((Cluster)sphereCluster);
        }
        return clustering;
    }

    public Clustering getClusteringResult() {
        return null;
    }

    public double[] getInstanceValues(Instance instance) {
        int n = instance.numValues();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = instance.value(i);
        }
        return dArray;
    }

    private Integer remap(MicroCluster microCluster) {
        if (this.mapper_id.containsKey(microCluster.mcc.id)) {
            return this.mapper_id.get(microCluster.mcc.id);
        }
        Integer n = this.sequence++;
        this.mapper_id.put(microCluster.mcc.id, n);
        this.mapper_mc.put(n, microCluster);
        return n;
    }

    public List<StreamMOA_MCODResult> sm_update(double[][] dArray) {
        DenseInstance denseInstance = null;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(dArray[0].length);
        for (int i = 0; i < dArray[0].length; ++i) {
            arrayList.add(new Attribute("Dim " + i));
        }
        Instances instances = new Instances(null, arrayList, 0);
        ArrayList<StreamMOA_MCODResult> arrayList2 = new ArrayList<StreamMOA_MCODResult>();
        for (int i = 0; i < dArray.length; ++i) {
            denseInstance = new DenseInstance(1.0, dArray[i]);
            denseInstance.setDataset(instances);
            this.ProcessNewStreamObj((Instance)denseInstance);
            ISBIndex.ISBNode iSBNode = (ISBIndex.ISBNode)this.windowNodes.lastElement();
            StreamMOA_MCODResult streamMOA_MCODResult = new StreamMOA_MCODResult();
            if (iSBNode.nodeType == ISBIndex.ISBNode.NodeType.OUTLIER) {
                streamMOA_MCODResult.setOutlier(true);
                streamMOA_MCODResult.setOutlierId(String.valueOf(iSBNode.id));
            } else if (iSBNode.nodeType == ISBIndex.ISBNode.NodeType.INLIER_MC) {
                Integer n = this.remap(iSBNode.mc);
                if (n != null) {
                    streamMOA_MCODResult.setId(n);
                }
            } else {
                double d = -1.0;
                MicroCluster microCluster = null;
                Object object = iSBNode.Rmc.iterator();
                while (object.hasNext()) {
                    MicroCluster microCluster2 = (MicroCluster)object.next();
                    double d2 = this.GetEuclideanDist(iSBNode, microCluster2.mcc);
                    if (d != -1.0 && !(d2 < d)) continue;
                    microCluster = microCluster2;
                }
                if (microCluster != null && (object = this.remap(microCluster)) != null) {
                    streamMOA_MCODResult.setId((Integer)object);
                }
            }
            arrayList2.add(streamMOA_MCODResult);
        }
        return arrayList2;
    }

    private double GetEuclideanDist(ISBIndex.ISBNode iSBNode, ISBIndex.ISBNode iSBNode2) {
        double d = 0.0;
        int n = iSBNode.obj.dimensions();
        for (int i = 0; i < n; ++i) {
            double d2 = iSBNode.obj.get(i) - iSBNode2.obj.get(i);
            d += Math.pow(d2, 2.0);
        }
        return Math.sqrt(d);
    }

    public boolean recheckOutlier(String string) {
        Long l = Long.parseLong(string);
        if (l < this.GetWindowStart()) {
            return true;
        }
        for (MyBaseOutlierDetector.Outlier outlier : this.getOutliersResult()) {
            if (outlier.id != l) continue;
            return true;
        }
        return false;
    }

    private Long GetWindowEnd() {
        return this.objId - 1L;
    }

    private Long GetWindowStart() {
        Long l = this.GetWindowEnd() - (long)this.m_WindowSize + 1L;
        if (l < FIRST_OBJ_ID) {
            l = FIRST_OBJ_ID;
        }
        return l;
    }
}

