/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone.filter;

import com.nexagis.jawbone.filter.TermFilter;

public final class SoundFilter
implements TermFilter {
    private String termCode = null;
    private boolean ignoreCase = false;

    private SoundFilter() {
    }

    public SoundFilter(String string, boolean bl) {
        this.termCode = SoundFilter.getSoundexCode(string);
        this.ignoreCase = bl;
    }

    public boolean accept(String string) {
        String string2 = SoundFilter.getSoundexCode(string);
        if (this.ignoreCase) {
            return string2.equalsIgnoreCase(this.termCode);
        }
        return string2.equals(this.termCode);
    }

    private static int getIntValue(char c) {
        int n = 0;
        switch (c) {
            case 'b': 
            case 'f': 
            case 'p': 
            case 'v': {
                n = 1;
                break;
            }
            case 'c': 
            case 'g': 
            case 'j': 
            case 'k': 
            case 'q': 
            case 's': 
            case 'x': 
            case 'z': {
                n = 2;
                break;
            }
            case 'd': 
            case 't': {
                n = 3;
                break;
            }
            case 'l': {
                n = 4;
                break;
            }
            case 'm': 
            case 'n': {
                n = 5;
                break;
            }
            case 'r': {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static String getSoundexCode(String string) {
        int n;
        if (string == null || string.length() < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append(string.charAt(0));
        String string2 = string.toLowerCase();
        int n2 = SoundFilter.getIntValue(string2.charAt(0));
        int n3 = -1;
        int n4 = string2.length();
        for (n = 1; n < n4 && stringBuilder.length() < 4; ++n) {
            n3 = SoundFilter.getIntValue(string2.charAt(n));
            if (n3 != n2 && n3 != 0) {
                stringBuilder.append(Integer.toString(n3));
            }
            n2 = n3;
        }
        n = stringBuilder.length() - 4;
        if (n < 0) {
            while (n < 0) {
                stringBuilder.append("0");
                ++n;
            }
        }
        return stringBuilder.toString();
    }
}

