/*
 * Decompiled with CFR 0.152.
 */
package dr.app.beast;

import dr.app.beast.BeastVersion;
import dr.inference.model.ParameterParser;
import dr.inference.model.StatisticParser;
import dr.util.Citation;
import dr.util.Pair;
import dr.util.Version;
import dr.xml.AttributeParser;
import dr.xml.AttributesParser;
import dr.xml.PropertyParser;
import dr.xml.UserInput;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class BeastParser
extends XMLParser {
    public static final String RELEASE = "release";
    public static final String DEV = "development";
    public static final String PARSER_PROPERTIES_SUFFIX = "_parsers.properties";
    public String parsers;

    public BeastParser(String[] stringArray, List<String> list, boolean bl, boolean bl2, boolean bl3, Version version) {
        super(bl, bl2, bl3, version);
        Object object;
        this.addCitable(BeastVersion.INSTANCE);
        this.setup(stringArray);
        if (bl) {
            System.out.println("Built-in parsers:");
            object = this.getParsers();
            while (object.hasNext()) {
                XMLObjectParser xMLObjectParser = (XMLObjectParser)object.next();
                System.out.println(xMLObjectParser.getParserName());
            }
        }
        try {
            object = new Properties();
            ((Properties)object).load(this.getClass().getResourceAsStream("beast.properties"));
            this.parsers = ((Properties)object).getProperty("parsers");
            if (System.getProperty("parsers") != null) {
                this.parsers = System.getProperty("parsers");
            }
            if (this.parsers.equalsIgnoreCase(DEV)) {
                this.parserWarnings = true;
            }
            this.loadProperties(this.getClass(), "release_parsers.properties", bl, this.parserWarnings, false);
            if (this.parsers != null && !this.parsers.equalsIgnoreCase(RELEASE)) {
                if (this.parsers.equalsIgnoreCase(DEV)) {
                    System.out.println("Loading additional development parsers from " + this.parsers + PARSER_PROPERTIES_SUFFIX + ", which is additional set of parsers only available for development version ...");
                }
                this.loadProperties(this.getClass(), this.parsers + PARSER_PROPERTIES_SUFFIX, bl, this.parserWarnings, true);
            }
            if (list != null) {
                for (String string : list) {
                    this.loadProperties(this.getClass(), string + PARSER_PROPERTIES_SUFFIX, bl, bl, true);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void loadProperties(Class clazz, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        InputStream inputStream;
        if (bl) {
            if (string.equalsIgnoreCase("release_parsers.properties")) {
                System.out.println("\nAlways loading " + string + ":");
            } else {
                System.out.println("\n\nLoading additional parsers (" + string + "):");
            }
        }
        if ((inputStream = clazz.getResourceAsStream(string)) == null) {
            throw new RuntimeException("Parsers file not found: " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            block22: {
                if (bl && string2.trim().startsWith("#")) {
                    System.out.println(string2);
                }
                if (string2.trim().length() > 0 && !string2.trim().startsWith("#")) {
                    try {
                        Field[] fieldArray;
                        boolean bl4;
                        Class<?> clazz2;
                        if (string2.contains("Vector")) {
                            System.out.println("");
                        }
                        if (XMLObjectParser.class.isAssignableFrom(clazz2 = Class.forName(string2))) {
                            bl4 = this.addXMLObjectParser((XMLObjectParser)clazz2.newInstance(), bl3);
                            if (bl) {
                                System.out.println((bl4 ? "Replaced" : "Loaded") + " parser: " + clazz2.getName());
                            } else if (bl2 && bl4) {
                                System.out.println("WARNING: parser - " + clazz2.getName() + " in " + string + " is duplicated, which is REPLACING the same parser loaded previously.\n");
                            }
                            break block22;
                        }
                        bl4 = false;
                        for (Field field : fieldArray = clazz2.getDeclaredFields()) {
                            if (!XMLObjectParser.class.isAssignableFrom(field.getType())) continue;
                            try {
                                boolean bl5 = this.addXMLObjectParser((XMLObjectParser)field.get(null), bl3);
                                if (bl) {
                                    System.out.println((bl5 ? "Replaced" : "Loaded") + " parser: " + clazz2.getName() + "." + field.getName());
                                } else if (bl2 && bl5) {
                                    System.out.println("WARNING: parser - " + clazz2.getName() + " in " + string + " is duplicated, which is REPLACING the same parser loaded previously.\n");
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                System.err.println("Failed to install parser: " + illegalArgumentException.getMessage());
                            }
                            bl4 = true;
                        }
                        if (!bl4) {
                            throw new IllegalArgumentException(clazz2.getName() + " is not of type XMLObjectParser and doesn't contain any static members of this type");
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("\nFailed to load parser: " + exception.getMessage());
                        System.err.println("line = " + string2 + "\n");
                    }
                }
            }
            string2 = bufferedReader.readLine();
        }
        if (bl) {
            System.out.println("load " + string + " successfully.\n");
        }
    }

    @Override
    protected void executingRunnable() {
        Set set;
        Logger.getLogger("dr.apps.beast").info("\nCitations for this analysis: ");
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        linkedHashMap.put("Framework", new LinkedHashSet());
        for (Pair<String, String> object : this.getCitationStore().keySet()) {
            set = (LinkedHashSet<Pair<String, String>>)linkedHashMap.get(object.fst);
            if (set == null) {
                set = new LinkedHashSet<Pair<String, String>>();
                linkedHashMap.put((String)object.fst, set);
            }
            set.add(object);
        }
        for (String string : linkedHashMap.keySet()) {
            Logger.getLogger("dr.apps.beast").info("\n" + string.toUpperCase());
            set = (Set)linkedHashMap.get(string);
            for (Pair pair : set) {
                Logger.getLogger("dr.apps.beast").info((String)pair.snd + ":");
                for (Citation citation : this.getCitationStore().get(pair)) {
                    Logger.getLogger("dr.apps.beast").info("\t" + citation.toString());
                }
            }
        }
        this.getCitationStore().clear();
        Logger.getLogger("dr.apps.beast").info("\n");
    }

    private void setup(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.storeObject(Integer.toString(i), stringArray[i]);
        }
        this.addXMLObjectParser(new PropertyParser());
        this.addXMLObjectParser(UserInput.STRING_PARSER);
        this.addXMLObjectParser(UserInput.DOUBLE_PARSER);
        this.addXMLObjectParser(UserInput.INTEGER_PARSER);
        this.addXMLObjectParser(new AttributeParser());
        this.addXMLObjectParser(new AttributesParser());
        this.addXMLObjectParser(new StatisticParser());
        this.addXMLObjectParser(new ParameterParser());
    }
}

