/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.Timer;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.Former;
import cern.colt.matrix.FormerFactory;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatStatistic;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tobject.ObjectFactory2D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import hep.aida.tfloat.bin.FloatBinFunction1D;
import hep.aida.tfloat.bin.FloatBinFunctions1D;

public class FloatFormatter
extends AbstractFormatter {
    private static final long serialVersionUID = 1L;

    public FloatFormatter() {
        this("%G");
    }

    public FloatFormatter(String string) {
        this.setFormat(string);
        this.setAlignment("decimal");
    }

    public static void demo1() {
        int n;
        float[][] fArrayArray = new float[][]{{3.0f, 0.0f, -3.4f, 0.0f}, {5.1f, 0.0f, 3.0123458f, 0.0f}, {16.37f, 0.0f, 2.5f, 0.0f}, {-16.3f, 0.0f, -3.0123457E-4f, -1.0f}, {1236.3457f, 0.0f, 7.0f, -1.2f}};
        String[] stringArray = new String[]{"%G", "%1.10G", "%f", "%1.2f", "%0.2e", null};
        int n2 = stringArray.length;
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.make(fArrayArray);
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        for (n = 0; n < n2; ++n) {
            String string = stringArray[n];
            stringArray2[n] = new FloatFormatter(string).toString(floatMatrix2D);
            stringArray3[n] = new FloatFormatter(string).toSourceCode(floatMatrix2D);
        }
        System.out.println("original:\n" + new FloatFormatter().toString(floatMatrix2D));
        for (n = 0; n < n2; ++n) {
            System.out.println("\nstring(" + stringArray[n] + "):\n" + stringArray2[n]);
            System.out.println("\nsourceCode(" + stringArray[n] + "):\n" + stringArray3[n]);
        }
    }

    public static void demo2() {
        int n;
        float[] fArray = new float[]{5.0f, 0.0f, -0.0f, Float.NaN, Float.NaN, Float.NaN, Float.MIN_VALUE, Float.MAX_VALUE, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        String[] stringArray = new String[]{"%G", "%1.19G"};
        int n2 = stringArray.length;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            String string = stringArray[n];
            stringArray2[n] = new FloatFormatter(string).toString(denseFloatMatrix1D);
            int n3 = 0;
            while ((long)n3 < denseFloatMatrix1D.size()) {
                System.out.println(String.valueOf(denseFloatMatrix1D.get(n3)));
                ++n3;
            }
        }
        System.out.println("original:\n" + new FloatFormatter().toString(denseFloatMatrix1D));
        for (n = 0; n < n2; ++n) {
            System.out.println("\nstring(" + stringArray[n] + "):\n" + stringArray2[n]);
        }
    }

    public static void demo3(int n, float f) {
        int n2;
        Timer timer = new Timer();
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.make(n, n, f);
        timer.reset().start();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (--n3 >= 0) {
            n2 = n;
            while (--n2 >= 0) {
                stringBuffer.append(floatMatrix2D.getQuick(n3, n2));
            }
        }
        stringBuffer = null;
        timer.stop().display();
        timer.reset().start();
        Former former = new FormerFactory().create("%G");
        stringBuffer = new StringBuffer();
        n2 = n;
        while (--n2 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                stringBuffer.append(former.form(floatMatrix2D.getQuick(n2, n4)));
            }
        }
        stringBuffer = null;
        timer.stop().display();
        timer.reset().start();
        String string = new FloatFormatter(null).toString(floatMatrix2D);
        System.out.println(string);
        string = null;
        timer.stop().display();
        timer.reset().start();
        string = new FloatFormatter("%G").toString(floatMatrix2D);
        System.out.println(string);
        string = null;
        timer.stop().display();
    }

    public static void demo4() {
        float[][] fArrayArray = new float[][]{{3.0f, 0.0f, -3.4f, 0.0f}, {5.1f, 0.0f, 3.0123458f, 0.0f}, {16.37f, 0.0f, 2.5f, 0.0f}, {-16.3f, 0.0f, -3.0123457E-4f, -1.0f}, {1236.3457f, 0.0f, 7.0f, -1.2f}};
        String[] stringArray = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.make(fArrayArray);
        System.out.println("\n\n" + new FloatFormatter("%G").toTitleString(floatMatrix2D, stringArray2, stringArray, "rowAxis", "colAxis", "VM Performance: Provider vs. matrix density"));
    }

    public static void demo5() {
        float[][] fArrayArray = new float[][]{{3.0f, 0.0f, -3.4f, 0.0f}, {5.1f, 0.0f, 3.0123458f, 0.0f}, {16.37f, 0.0f, 2.5f, 0.0f}, {-16.3f, 0.0f, -3.0123457E-4f, -1.0f}, {1236.3457f, 0.0f, 7.0f, -1.2f}};
        String[] stringArray = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(FloatFactory2D.dense.make(fArrayArray));
        System.out.println(new FloatFormatter("%G").toTitleString(FloatFactory2D.dense.make(fArrayArray), stringArray2, stringArray, "vendor", "density", "title"));
    }

    public static void demo6() {
        float[][] fArrayArray = new float[][]{{3.0f, 0.0f, -3.4f, 0.0f}, {5.1f, 0.0f, 3.0123458f, 0.0f}, {16.37f, 0.0f, 2.5f, 0.0f}, {-16.3f, 0.0f, -3.0123457E-4f, -1.0f}, {1236.3457f, 0.0f, 7.0f, -1.2f}};
        String[] stringArray = new String[]{"W", "X", "Y", "Z"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(new FloatFormatter().toString(FloatFactory2D.dense.make(fArrayArray)));
        System.out.println(new FloatFormatter().toTitleString(FloatFactory2D.dense.make(fArrayArray), stringArray2, stringArray, "vendor", "density", "title"));
    }

    public static void demo7() {
        float[][] fArrayArray = new float[][]{{5.0f, 10.0f, 20.0f, 40.0f}, {7.0f, 8.0f, 6.0f, 7.0f}, {12.0f, 10.0f, 20.0f, 19.0f}, {3.0f, 1.0f, 5.0f, 6.0f}};
        String[] stringArray = new String[]{"1996", "1997", "1998", "1999"};
        String[] stringArray2 = new String[]{"PowerBar", "Benzol", "Mercedes", "Sparcling"};
        String string = "CPU";
        String string2 = "Year";
        String string3 = "CPU performance over time [nops/sec]";
        FloatBinFunctions1D floatBinFunctions1D = FloatBinFunctions1D.functions;
        FloatBinFunction1D[] floatBinFunction1DArray = new FloatBinFunction1D[8];
        floatBinFunction1DArray[0] = FloatBinFunctions1D.mean;
        floatBinFunction1DArray[1] = FloatBinFunctions1D.rms;
        floatBinFunction1DArray[2] = FloatBinFunctions1D.quantile(0.25f);
        floatBinFunction1DArray[3] = FloatBinFunctions1D.median;
        floatBinFunction1DArray[4] = FloatBinFunctions1D.quantile(0.75f);
        floatBinFunction1DArray[5] = FloatBinFunctions1D.stdDev;
        floatBinFunction1DArray[6] = FloatBinFunctions1D.min;
        floatBinFunction1DArray[7] = FloatBinFunctions1D.max;
        FloatBinFunction1D[] floatBinFunction1DArray2 = floatBinFunction1DArray;
        String string4 = "%1.2G";
        System.out.println(new FloatFormatter(string4).toTitleString(FloatFactory2D.dense.make(fArrayArray), stringArray2, stringArray, string, string2, string3, floatBinFunction1DArray2));
    }

    protected String form(FloatMatrix1D floatMatrix1D, int n, Former former) {
        return former.form(floatMatrix1D.get(n));
    }

    protected String form(AbstractMatrix1D abstractMatrix1D, int n, Former former) {
        return this.form((FloatMatrix1D)abstractMatrix1D, n, former);
    }

    public String[][] format(FloatMatrix2D floatMatrix2D) {
        String[][] stringArray = new String[floatMatrix2D.rows()][floatMatrix2D.columns()];
        int n = floatMatrix2D.rows();
        while (--n >= 0) {
            stringArray[n] = this.formatRow(floatMatrix2D.viewRow(n));
        }
        return stringArray;
    }

    protected String[][] format(AbstractMatrix2D abstractMatrix2D) {
        return this.format((FloatMatrix2D)abstractMatrix2D);
    }

    protected int indexOfDecimalPoint(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            n = string.lastIndexOf(101);
        }
        if (n < 0) {
            n = string.lastIndexOf(69);
        }
        if (n < 0) {
            n = string.length();
        }
        return n;
    }

    protected int lead(String string) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(string);
        }
        return super.lead(string);
    }

    public String toSourceCode(FloatMatrix1D floatMatrix1D) {
        FloatFormatter floatFormatter = (FloatFormatter)this.clone();
        floatFormatter.setPrintShape(false);
        floatFormatter.setColumnSeparator(", ");
        String string = "{";
        String string2 = "};";
        return string + floatFormatter.toString(floatMatrix1D) + string2;
    }

    public String toSourceCode(FloatMatrix2D floatMatrix2D) {
        FloatFormatter floatFormatter = (FloatFormatter)this.clone();
        String string = this.blanks(3);
        floatFormatter.setPrintShape(false);
        floatFormatter.setColumnSeparator(", ");
        floatFormatter.setRowSeparator("},\n" + string + "{");
        String string2 = "{\n" + string + "{";
        String string3 = "}\n};";
        return string2 + floatFormatter.toString(floatMatrix2D) + string3;
    }

    public String toSourceCode(FloatMatrix3D floatMatrix3D) {
        FloatFormatter floatFormatter = (FloatFormatter)this.clone();
        String string = this.blanks(3);
        String string2 = this.blanks(6);
        floatFormatter.setPrintShape(false);
        floatFormatter.setColumnSeparator(", ");
        floatFormatter.setRowSeparator("},\n" + string2 + "{");
        floatFormatter.setSliceSeparator("}\n" + string + "},\n" + string + "{\n" + string2 + "{");
        String string3 = "{\n" + string + "{\n" + string2 + "{";
        String string4 = "}\n" + string + "}\n}";
        return string3 + floatFormatter.toString(floatMatrix3D) + string4;
    }

    public String toString(FloatMatrix1D floatMatrix1D) {
        FloatMatrix2D floatMatrix2D = floatMatrix1D.like2D(1, (int)floatMatrix1D.size());
        floatMatrix2D.viewRow(0).assign(floatMatrix1D);
        return this.toString(floatMatrix2D);
    }

    public String toString(FloatMatrix2D floatMatrix2D) {
        return super.toString(floatMatrix2D);
    }

    public String toString(FloatMatrix3D floatMatrix3D) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.printShape;
        this.printShape = false;
        for (int i = 0; i < floatMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toString(floatMatrix3D.viewSlice(i)));
        }
        this.printShape = bl;
        if (this.printShape) {
            stringBuffer.insert(0, FloatFormatter.shape(floatMatrix3D) + "\n");
        }
        return stringBuffer.toString();
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        return this.toString((FloatMatrix2D)abstractMatrix2D);
    }

    protected String toTitleString(FloatMatrix2D floatMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3) {
        if (floatMatrix2D.size() == 0L) {
            return "Empty matrix";
        }
        Object[][] objectArray = this.format(floatMatrix2D);
        this.align((String[][])objectArray);
        return new ObjectFormatter().toTitleString(ObjectFactory2D.dense.make(objectArray), stringArray, stringArray2, string, string2, string3);
    }

    public String toTitleString(FloatMatrix2D floatMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3, FloatBinFunction1D[] floatBinFunction1DArray) {
        int n;
        Object object;
        if (floatMatrix2D.size() == 0L) {
            return "Empty matrix";
        }
        if (floatBinFunction1DArray == null || floatBinFunction1DArray.length == 0) {
            return this.toTitleString(floatMatrix2D, stringArray, stringArray2, string, string2, string3);
        }
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.like(floatMatrix2D.rows(), floatBinFunction1DArray.length);
        FloatMatrix2D floatMatrix2D3 = floatMatrix2D.like(floatBinFunction1DArray.length, floatMatrix2D.columns());
        FloatStatistic.aggregate(floatMatrix2D, floatBinFunction1DArray, floatMatrix2D3);
        FloatStatistic.aggregate(floatMatrix2D.viewDice(), floatBinFunction1DArray, floatMatrix2D2.viewDice());
        FloatMatrix2D floatMatrix2D4 = floatMatrix2D.like(floatMatrix2D.rows() + floatBinFunction1DArray.length, floatMatrix2D.columns());
        floatMatrix2D4.viewPart(0, 0, floatMatrix2D.rows(), floatMatrix2D.columns()).assign(floatMatrix2D);
        floatMatrix2D4.viewPart(floatMatrix2D.rows(), 0, floatBinFunction1DArray.length, floatMatrix2D.columns()).assign(floatMatrix2D3);
        floatMatrix2D3 = null;
        Object[][] objectArray = this.format(floatMatrix2D4);
        this.align((String[][])objectArray);
        floatMatrix2D4 = null;
        Object[][] objectArray2 = this.format(floatMatrix2D2);
        this.align((String[][])objectArray2);
        floatMatrix2D2 = null;
        ObjectMatrix2D objectMatrix2D = ObjectFactory2D.dense.make(floatMatrix2D.rows() + floatBinFunction1DArray.length, floatMatrix2D.columns() + floatBinFunction1DArray.length + 1);
        objectMatrix2D.viewPart(0, 0, floatMatrix2D.rows() + floatBinFunction1DArray.length, floatMatrix2D.columns()).assign(objectArray);
        objectMatrix2D.viewColumn(floatMatrix2D.columns()).assign("|");
        objectMatrix2D.viewPart(0, floatMatrix2D.columns() + 1, floatMatrix2D.rows(), floatBinFunction1DArray.length).assign(objectArray2);
        objectArray = null;
        objectArray2 = null;
        if (stringArray2 != null) {
            object = new ObjectArrayList(stringArray2);
            ((ObjectArrayList)object).add("|");
            for (n = 0; n < floatBinFunction1DArray.length; ++n) {
                ((ObjectArrayList)object).add(floatBinFunction1DArray[n].name());
            }
            stringArray2 = new String[((ObjectArrayList)object).size()];
            ((ObjectArrayList)object).toArray(stringArray2);
        }
        if (stringArray != null) {
            object = new ObjectArrayList(stringArray);
            for (n = 0; n < floatBinFunction1DArray.length; ++n) {
                ((ObjectArrayList)object).add(floatBinFunction1DArray[n].name());
            }
            stringArray = new String[((ObjectArrayList)object).size()];
            ((ObjectArrayList)object).toArray(stringArray);
        }
        object = new ObjectFormatter().toTitleString(objectMatrix2D, stringArray, stringArray2, string, string2, string3);
        int n2 = n = ((String)object).length() + 1;
        int n3 = Math.max(0, string == null ? 0 : string.length() - floatMatrix2D.rows() - floatBinFunction1DArray.length);
        for (int i = 0; i < floatBinFunction1DArray.length + 1 + n3; ++i) {
            n2 = n;
            n = ((String)object).lastIndexOf(this.rowSeparator, n - 1);
        }
        StringBuffer stringBuffer = new StringBuffer((String)object);
        stringBuffer.insert(n2, this.rowSeparator + this.repeat('-', n2 - n - 1));
        return stringBuffer.toString();
    }

    public String toTitleString(FloatMatrix3D floatMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4, FloatBinFunction1D[] floatBinFunction1DArray) {
        if (floatMatrix3D.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < floatMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(floatMatrix3D.viewSlice(i), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[i], floatBinFunction1DArray));
        }
        return stringBuffer.toString();
    }

    private String xtoTitleString(FloatMatrix3D floatMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4) {
        if (floatMatrix3D.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < floatMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(floatMatrix3D.viewSlice(i), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[i]));
        }
        return stringBuffer.toString();
    }
}

