/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import java.io.Serializable;
import uk.ac.rhul.cs.cl1.CohesivenessFunction;
import uk.ac.rhul.cs.cl1.DiceSimilarity;
import uk.ac.rhul.cs.cl1.JaccardSimilarity;
import uk.ac.rhul.cs.cl1.MatchingScore;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;
import uk.ac.rhul.cs.cl1.SimilarityFunction;
import uk.ac.rhul.cs.cl1.SimpsonCoefficient;
import uk.ac.rhul.cs.cl1.seeding.SeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.UnusedNodesSeedGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterONEAlgorithmParameters
implements Serializable {
    protected int minSize = 3;
    protected Double minDensity = null;
    protected double overlapThreshold = 0.8;
    protected double haircutThreshold = 0.0;
    protected int kCoreThreshold = 0;
    protected double nodePenalty = 2.0;
    protected boolean fluffClusters = false;
    protected String mergingMethod = "single";
    protected SeedGenerator seedGenerator = new UnusedNodesSeedGenerator();
    protected SimilarityFunction<NodeSet> similarityFunction = new MatchingScore<NodeSet>();

    public int getKCoreThreshold() {
        return this.kCoreThreshold;
    }

    public double getHaircutThreshold() {
        return this.haircutThreshold;
    }

    public String getMergingMethodName() {
        return this.mergingMethod;
    }

    public Double getMinDensity() {
        return this.minDensity;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public double getNodePenalty() {
        return this.nodePenalty;
    }

    public double getOverlapThreshold() {
        return this.overlapThreshold;
    }

    public QualityFunction getQualityFunction() {
        return new CohesivenessFunction(this.nodePenalty);
    }

    public SeedGenerator getSeedGenerator() {
        return this.seedGenerator;
    }

    public SimilarityFunction<NodeSet> getSimilarityFunction() {
        return this.similarityFunction;
    }

    public boolean isFluffClusters() {
        return this.fluffClusters;
    }

    public void setKCoreThreshold(int kCoreThreshold) {
        this.kCoreThreshold = kCoreThreshold;
    }

    public void setFluffClusters(boolean fluffClusters) {
        this.fluffClusters = fluffClusters;
    }

    public void setHaircutThreshold(double haircutThreshold) {
        this.haircutThreshold = haircutThreshold;
    }

    public void setMergingMethodName(String mergingMethod) {
        this.mergingMethod = mergingMethod.toLowerCase();
    }

    public void setMinDensity(Double minDensity) {
        this.minDensity = minDensity == null ? null : Double.valueOf(Math.max(0.0, minDensity));
    }

    public void setMinSize(int minSize) {
        this.minSize = Math.max(1, minSize);
    }

    public void setNodePenalty(double penalty) {
        this.nodePenalty = penalty;
    }

    public void setOverlapThreshold(double overlapThreshold) {
        this.overlapThreshold = Math.max(0.0, overlapThreshold);
    }

    public void setSeedGenerator(String seedMethodSpec) throws InstantiationException {
        this.seedGenerator = SeedGenerator.fromString(seedMethodSpec);
    }

    public void setSeedGenerator(SeedGenerator seedGenerator) {
        this.seedGenerator = seedGenerator;
    }

    public void setSimilarityFunction(String similarityFunctionName) throws InstantiationException {
        if (similarityFunctionName.equals("match")) {
            this.similarityFunction = new MatchingScore<NodeSet>();
        } else if (similarityFunctionName.equals("meet/min") || similarityFunctionName.equals("simpson")) {
            this.similarityFunction = new SimpsonCoefficient<NodeSet>();
        } else if (similarityFunctionName.equals("jaccard")) {
            this.similarityFunction = new JaccardSimilarity<NodeSet>();
        } else if (similarityFunctionName.equals("dice")) {
            this.similarityFunction = new DiceSimilarity<NodeSet>();
        } else {
            throw new InstantiationException("Unknown similarity function: " + similarityFunctionName);
        }
    }

    public void setSimilarityFunction(SimilarityFunction<NodeSet> func) {
        this.similarityFunction = func;
    }

    public boolean isHaircutNeeded() {
        return this.haircutThreshold > 0.0 && this.haircutThreshold <= 1.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Minimum size: " + this.minSize + "\n");
        sb.append("Minimum density: " + this.minDensity + "\n");
        sb.append("Overlap threshold: " + this.overlapThreshold + "\n");
        sb.append("Haircut threshold: " + this.haircutThreshold + "\n");
        sb.append("K-core threshold: " + this.kCoreThreshold + "\n");
        sb.append("Node penalty: " + this.nodePenalty + "\n");
        sb.append("Merging method: " + this.mergingMethod + "\n");
        sb.append("Seed generator: " + this.seedGenerator + "\n");
        sb.append("Similarity function: " + this.similarityFunction.getName() + "\n");
        return sb.toString();
    }
}

