/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class HeightLimitedJLabelRenderer
extends JLabel
implements TableCellRenderer {
    int minHeight;

    public HeightLimitedJLabelRenderer(int minHeight) {
        this.setFont(this.getFont().deriveFont(11.0f));
        this.setOpaque(true);
        this.minHeight = minHeight;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value.toString());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        int currentRowHeight = table.getRowHeight(row);
        int rowMargin = table.getRowMargin();
        this.setSize(table.getColumnModel().getColumn(column).getWidth(), currentRowHeight - 2 * rowMargin);
        int textAreaPreferredHeight = (int)this.getPreferredSize().getHeight();
        if (currentRowHeight != Math.max(textAreaPreferredHeight + 2 * rowMargin, this.minHeight + 2 * rowMargin)) {
            table.setRowHeight(row, Math.max(textAreaPreferredHeight + 2 * rowMargin, this.minHeight + 2 * rowMargin));
        }
        return this;
    }
}

