## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(MultivariateAnalysis)

## -----------------------------------------------------------------------------
data("Dados.BIN")
Dados.BIN

## -----------------------------------------------------------------------------
#colocando nome nos individuos
rownames(Dados.BIN)=paste0("Indiv_",1:nrow(Dados.BIN))
Dist=Distancia(Dados.BIN,Metodo = 12)
Dist

## -----------------------------------------------------------------------------
resumo=SummaryDistancia(Dist)
resumo

## -----------------------------------------------------------------------------

Dendrograma(Dist,Metodo=3)

## -----------------------------------------------------------------------------

Tocher(Dist)

## -----------------------------------------------------------------------------
CoordenadasPrincipais(Dist)

