/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplayTree
implements EventList {
    private Entry root = null;
    private static Entry free = null;
    private int modCount = 0;

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public void clear() {
        while (this.root != null) {
            this.remove(this.root);
        }
    }

    @Override
    public void add(Event event) {
        Entry entry;
        double d = event.time();
        Entry entry2 = this.root;
        this.root = entry = this.add(event, null);
        if (entry2 != null) {
            Entry entry3 = this.root;
            Entry entry4 = this.root;
            Entry entry5 = null;
            boolean bl = false;
            while (!bl) {
                if (entry2.event.time() <= d) {
                    entry5 = entry2.right;
                    if (entry5 == null) {
                        entry3.right = entry2;
                        entry2.father = entry3;
                        entry4.left = null;
                        bl = true;
                        continue;
                    }
                    if (entry5.event.time() > d) {
                        entry3.right = entry2;
                        entry2.father = entry3;
                        entry3 = entry2;
                        entry2 = entry5;
                        continue;
                    }
                    entry2.right = entry5.left;
                    if (entry5.left != null) {
                        entry5.left.father = entry2;
                    }
                    entry3.right = entry5;
                    entry5.father = entry3;
                    entry5.left = entry2;
                    entry2.father = entry5;
                    entry3 = entry5;
                    entry2 = entry5.right;
                    if (entry2 != null) continue;
                    entry4.left = null;
                    bl = true;
                    continue;
                }
                entry5 = entry2.left;
                if (entry5 == null) {
                    entry4.left = entry2;
                    entry2.father = entry4;
                    entry3.right = null;
                    bl = true;
                    continue;
                }
                if (entry5.event.time() <= d) {
                    entry4.left = entry2;
                    entry2.father = entry4;
                    entry4 = entry2;
                    entry2 = entry5;
                    continue;
                }
                entry2.left = entry5.right;
                if (entry5.right != null) {
                    entry5.right.father = entry2;
                }
                entry4.left = entry5;
                entry5.father = entry4;
                entry5.right = entry2;
                entry2.father = entry5;
                entry4 = entry5;
                entry2 = entry5.left;
                if (entry2 != null) continue;
                entry3.right = null;
                bl = true;
            }
            entry5 = entry.left;
            entry.left = entry.right;
            entry.right = entry5;
        }
        ++this.modCount;
    }

    @Override
    public void addFirst(Event event) {
        if (this.root == null) {
            this.root = this.add(event, null);
        } else {
            Entry entry = this.root;
            while (entry.left != null) {
                entry = entry.left;
            }
            entry.left = this.add(event, entry);
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event event, Event event2) {
        Entry entry = this.findEntry(event2);
        if (entry == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        Entry entry2 = this.add(event, null);
        if (entry != this.root) {
            if (entry == entry.father.left) {
                entry.father.left = entry2;
            } else {
                entry.father.right = entry2;
            }
        } else {
            this.root = entry2;
        }
        entry2.father = entry.father;
        entry.father = entry2;
        entry2.right = entry;
        entry2.left = entry.left;
        if (entry2.left != null) {
            entry2.left.father = entry2;
        }
        entry.left = null;
        ++this.modCount;
    }

    @Override
    public void addAfter(Event event, Event event2) {
        Entry entry = this.findEntry(event2);
        if (entry == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        Entry entry2 = this.add(event, entry);
        entry2.right = entry.right;
        entry.right = entry2;
        if (entry2.right != null) {
            entry2.right.father = entry2;
        }
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        if (this.root == null) {
            return null;
        }
        Entry entry = this.root;
        while (entry.left != null) {
            entry = entry.left;
        }
        return entry.event;
    }

    @Override
    public Event getFirstOfClass(String string) {
        Entry entry = this.root;
        if (this.root != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        while (entry != null) {
            if (entry.event.getClass().getName().equals(string)) {
                return entry.event;
            }
            entry = this.successor(entry);
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> clazz) {
        Entry entry = this.root;
        if (this.root != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        while (entry != null) {
            if (entry.event.getClass() == clazz) {
                return (E)entry.event;
            }
            entry = this.successor(entry);
        }
        return null;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new SPItr();
    }

    @Override
    public boolean remove(Event event) {
        if (this.root == null) {
            return false;
        }
        Entry entry = this.findEntry(event);
        if (entry == null) {
            return false;
        }
        return this.remove(entry);
    }

    @Override
    public Event removeFirst() {
        if (this.root == null) {
            return null;
        }
        Entry entry = this.root;
        while (entry.left != null) {
            entry = entry.left;
        }
        Event event = entry.event;
        this.remove(entry);
        return event;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Contents of the event list SplayTree :");
        Entry entry = this.root;
        if (this.root != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        while (entry != null) {
            stringBuffer.append("\n" + PrintfFormat.g(8, 4, entry.event.time()) + " : " + entry.event.toString());
            entry = this.successor(entry);
        }
        return stringBuffer.toString();
    }

    private Entry add(Event event, Entry entry) {
        if (free == null) {
            return new Entry(event, null, null, entry);
        }
        Entry entry2 = free;
        free = SplayTree.free.right;
        entry2.event = event;
        entry2.right = null;
        entry2.left = null;
        entry2.father = entry;
        return entry2;
    }

    private void splay(Entry entry) {
        while (entry.father != null) {
            Entry entry2;
            boolean bl;
            Entry entry3 = entry.father;
            Entry entry4 = entry3.father;
            boolean bl2 = bl = entry == entry3.left;
            if (bl) {
                if (entry4 == null) {
                    entry3.father = entry;
                    entry3.left = entry.right;
                    if (entry3.left != null) {
                        entry3.left.father = entry3;
                    }
                    entry.right = entry3;
                    entry.father = null;
                    continue;
                }
                if (entry4.right == entry3) {
                    entry4.right = entry;
                    entry3.father = entry;
                    entry3.left = entry.right;
                    if (entry3.left != null) {
                        entry3.left.father = entry3;
                    }
                    entry.right = entry3;
                    entry.father = entry4;
                    continue;
                }
                entry2 = entry4.father;
                entry4.left = entry3.right;
                if (entry4.left != null) {
                    entry4.left.father = entry4;
                }
                entry3.right = entry4;
                entry4.father = entry3;
                entry3.left = entry.right;
                if (entry3.left != null) {
                    entry3.left.father = entry3;
                }
                entry3.father = entry;
                entry.right = entry3;
                entry.father = entry2;
                if (entry2 == null) continue;
                if (entry2.left == entry4) {
                    entry2.left = entry;
                    continue;
                }
                entry2.right = entry;
                continue;
            }
            if (entry4 == null) {
                entry3.father = entry;
                entry3.right = entry.left;
                if (entry3.right != null) {
                    entry3.right.father = entry3;
                }
                entry.left = entry3;
                entry.father = null;
                continue;
            }
            if (entry4.left == entry3) {
                entry4.left = entry;
                entry3.father = entry;
                entry3.right = entry.left;
                if (entry3.right != null) {
                    entry3.right.father = entry3;
                }
                entry.left = entry3;
                entry.father = entry4;
                continue;
            }
            entry2 = entry4.father;
            entry4.right = entry3.left;
            if (entry4.right != null) {
                entry4.right.father = entry4;
            }
            entry3.left = entry4;
            entry4.father = entry3;
            entry3.right = entry.left;
            if (entry3.right != null) {
                entry3.right.father = entry3;
            }
            entry3.father = entry;
            entry.left = entry3;
            entry.father = entry2;
            if (entry2 == null) continue;
            if (entry2.left == entry4) {
                entry2.left = entry;
                continue;
            }
            entry2.right = entry;
        }
    }

    private boolean remove(Entry entry) {
        if (this.root == null || entry == null) {
            return false;
        }
        this.splay(entry);
        Entry entry2 = entry.left;
        Entry entry3 = entry.right;
        if (entry2 != null) {
            entry2.father = null;
        }
        if (entry3 != null) {
            entry3.father = null;
        }
        entry.right = free;
        entry.left = null;
        entry.event = null;
        free = entry;
        if (entry3 == null) {
            this.root = entry2;
        } else if (entry2 == null) {
            this.root = entry3;
        } else {
            Entry entry4 = entry3;
            while (entry4.left != null) {
                entry4 = entry4.left;
            }
            this.splay(entry4);
            entry4.left = entry2;
            entry2.father = entry4;
            this.root = entry4;
        }
        ++this.modCount;
        return true;
    }

    private Entry findEntry(Event event) {
        Entry entry = this.root;
        double d = event.time();
        while (entry != null) {
            if (entry.event == event) {
                return entry;
            }
            if (d < entry.event.time()) {
                entry = entry.left;
                continue;
            }
            if (d > entry.event.time()) {
                entry = entry.right;
                continue;
            }
            Entry entry2 = entry;
            while (entry != null && entry.event.time() == d) {
                if (entry.event == event) {
                    return entry;
                }
                entry = this.predecessor(entry);
            }
            entry = entry2;
            while (entry != null && entry.event.time() == d) {
                if (entry.event == event) {
                    return entry;
                }
                entry = this.successor(entry);
            }
            return null;
        }
        return null;
    }

    private Entry successor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            entry = entry.right;
            while (entry.left != null) {
                entry = entry.left;
            }
        } else {
            while (entry.father != null && entry.father.right == entry) {
                entry = entry.father;
            }
            entry = entry.father;
        }
        return entry;
    }

    private Entry predecessor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.left != null) {
            entry = entry.left;
            while (entry.right != null) {
                entry = entry.right;
            }
        } else {
            while (entry.father != null && entry.father.left == entry) {
                entry = entry.father;
            }
            entry = entry.father;
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SPItr
    implements ListIterator<Event> {
        private Entry prev = null;
        private Entry next;
        private Entry lastRet;
        private int expectedModCount;
        private int nextIndex;

        SPItr() {
            this.next = SplayTree.this.root;
            if (this.next != null) {
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
            this.expectedModCount = SplayTree.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event event) {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null && event.time() > this.next.event.time()) {
                event.setTime(this.next.event.time());
            }
            if (this.prev != null && event.time() < this.prev.event.time()) {
                event.setTime(this.prev.event.time());
            }
            Entry entry = SplayTree.this.add(event, null);
            if (this.prev != null) {
                entry.father = this.prev;
                entry.right = this.prev.right;
                this.prev.right = entry;
                if (entry.right != null) {
                    entry.right.father = entry;
                }
            } else {
                if (this.next != SplayTree.this.root) {
                    if (this.next == this.next.father.left) {
                        this.next.father.left = entry;
                    } else {
                        this.next.father.right = entry;
                    }
                } else {
                    SplayTree.this.root = entry;
                }
                entry.father = this.next.father;
                this.next.father = entry;
                entry.right = this.next;
                entry.left = this.next.left;
                if (entry.left != null) {
                    entry.left.father = entry;
                }
                this.next.left = null;
            }
            this.prev = entry;
            ++this.nextIndex;
            this.lastRet = null;
            ++SplayTree.this.modCount;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prev != null;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event event = this.next.event;
            this.lastRet = this.next;
            this.prev = this.next;
            this.next = SplayTree.this.successor(this.next);
            return event;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event event = this.prev.event;
            this.lastRet = this.prev;
            this.next = this.prev;
            this.prev = SplayTree.this.predecessor(this.prev);
            return event;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                this.next = SplayTree.this.successor(this.next);
            } else {
                this.prev = SplayTree.this.predecessor(this.prev);
                --this.nextIndex;
            }
            SplayTree.this.remove(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event event) {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            Entry entry = SplayTree.this.predecessor(this.lastRet);
            Entry entry2 = SplayTree.this.successor(this.lastRet);
            if (entry != null && event.time() < entry.event.time()) {
                event.setTime(entry.event.time());
            }
            if (entry2 != null && event.time() > entry2.event.time()) {
                event.setTime(entry2.event.time());
            }
            this.lastRet.event = event;
        }
    }

    private static class Entry {
        Event event;
        Entry father;
        Entry left;
        Entry right;

        Entry(Event event, Entry entry, Entry entry2, Entry entry3) {
            this.event = event;
            this.left = entry;
            this.right = entry2;
            this.father = entry3;
        }
    }
}

