/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.IDomain;
import ec.tstoolkit.timeseries.IPeriod;
import java.util.Arrays;

public class Days
implements IDomain {
    private final int[] m_days;

    public Days() {
        this.m_days = null;
    }

    public Days(Day[] days) {
        this.m_days = new int[days.length];
        for (int i = 0; i < days.length; ++i) {
            this.m_days[i] = days[i].getId();
        }
    }

    public Days(Days days) {
        this.m_days = (int[])days.m_days.clone();
    }

    Days(int[] days, int start, int n) {
        this.m_days = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_days[i] = days[start + i];
        }
    }

    @Override
    public IPeriod get(int idx) {
        return new Day(this.m_days[idx]);
    }

    @Override
    public int getLength() {
        return this.m_days == null ? 0 : this.m_days.length;
    }

    @Override
    public int search(Day day) {
        if (this.m_days == null) {
            return -1;
        }
        return Arrays.binarySearch(this.m_days, day.getId());
    }
}

