/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.impl.DriverMap;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;

public class RDBMakerCreator
implements ModelMakerCreator {
    public ModelMaker create(Model desc, Resource root) {
        return ModelFactory.createModelRDBMaker(RDBMakerCreator.createConnection(desc, root));
    }

    public static IDBConnection createConnection(Model description, Resource root) {
        Resource connection = description.listStatements(root, JenaModelSpec.hasConnection, (RDFNode)null).nextStatement().getResource();
        String url = RDBMakerCreator.getURL(description, connection, JenaModelSpec.dbURL);
        String user = RDBMakerCreator.getString(description, connection, JenaModelSpec.dbUser);
        String password = RDBMakerCreator.getString(description, connection, JenaModelSpec.dbPassword);
        String className = RDBMakerCreator.getClassName(description, connection);
        String dbType = RDBMakerCreator.getDbType(description, connection);
        RDBMakerCreator.loadDrivers(dbType, className);
        return ModelFactory.createSimpleRDBConnection(url, user, password, dbType);
    }

    public static String getDbType(Model description, Resource connection) {
        return RDBMakerCreator.getString(description, connection, JenaModelSpec.dbType);
    }

    public static String getClassName(Model description, Resource root) {
        Statement cnStatement = description.getProperty(root, JenaModelSpec.dbClass);
        if (cnStatement == null) {
            return DriverMap.get(RDBMakerCreator.getDbType(description, root));
        }
        return cnStatement == null ? null : cnStatement.getString();
    }

    public static String getURL(Model description, Resource root, Property p) {
        return description.getRequiredProperty(root, p).getResource().getURI();
    }

    public static String getString(Model description, Resource root, Property p) {
        return description.getRequiredProperty(root, p).getString();
    }

    public static void loadDrivers(String dbType, String className) {
        try {
            Class.forName("com.hp.hpl.jena.db.impl.Driver_" + dbType);
            if (className != null) {
                Class.forName(className);
            }
        }
        catch (ClassNotFoundException c) {
            throw new JenaException(c);
        }
    }
}

