/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles.C45;

import java.util.Enumeration;
import keel.Algorithms.ImbalancedClassification.Ensembles.C45.Attribute;
import keel.Algorithms.ImbalancedClassification.Ensembles.C45.Classification;
import keel.Algorithms.ImbalancedClassification.Ensembles.C45.Cut;
import keel.Algorithms.ImbalancedClassification.Ensembles.C45.Dataset;

public class SelectCut {
    private int minItemsets;
    private Dataset dataset;

    public SelectCut(int nObj, Dataset allData) {
        this.minItemsets = nObj;
        this.dataset = allData;
    }

    public final Cut selectModel(Dataset data) {
        double averageInfoGain = 0.0;
        Cut best = null;
        Cut noCut = null;
        int models = 0;
        boolean multiVal = true;
        try {
            int i;
            Classification checkClassification = new Classification(data);
            noCut = new Cut(checkClassification);
            if (checkClassification.getTotal() < (double)(2 * this.minItemsets) || checkClassification.getTotal() == checkClassification.perClass(checkClassification.maxClass())) {
                return noCut;
            }
            if (this.dataset != null) {
                Enumeration enum2 = data.enumerateAttributes();
                while (enum2.hasMoreElements()) {
                    Attribute attribute = (Attribute)enum2.nextElement();
                    if (!attribute.isContinuous() && !((double)attribute.numValues() < 0.3 * (double)this.dataset.numItemsets())) continue;
                    multiVal = false;
                    break;
                }
            }
            Cut[] current = new Cut[data.numAttributes()];
            double sumOfWeights = data.sumOfWeights();
            for (i = 0; i < data.numAttributes(); ++i) {
                if (i != data.getClassIndex()) {
                    current[i] = new Cut(i, this.minItemsets, sumOfWeights);
                    current[i].classify(data);
                    if (!current[i].checkModel()) continue;
                    if (this.dataset != null) {
                        if (!data.getAttribute(i).isContinuous() && !multiVal && !((double)data.getAttribute(i).numValues() < 0.3 * (double)this.dataset.numItemsets())) continue;
                        averageInfoGain += current[i].getInfoGain();
                        ++models;
                        continue;
                    }
                    averageInfoGain += current[i].getInfoGain();
                    ++models;
                    continue;
                }
                current[i] = null;
            }
            if (models == 0) {
                return noCut;
            }
            averageInfoGain /= (double)models;
            double minResult = 0.0;
            for (i = 0; i < data.numAttributes(); ++i) {
                if (i == data.getClassIndex() || !current[i].checkModel() || !(current[i].getInfoGain() >= averageInfoGain - 0.001) || !(current[i].getGainRatio() > minResult)) continue;
                best = current[i];
                minResult = current[i].getGainRatio();
            }
            if (minResult == 0.0) {
                return noCut;
            }
            best.classification().addWithUnknownValue(data, best.attributeIndex());
            if (this.dataset != null) {
                best.setCutPoint(this.dataset);
            }
            return best;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

