/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.intarray.mut;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.intarray.IntArrayIndividual;
import net.sourceforge.jclec.intarray.IntArrayMutator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SeveralLociMutator
extends IntArrayMutator
implements IConfigure {
    private static final long serialVersionUID = 3258415014955071027L;
    private int numberOfMutationPoints;
    private transient int[] mutationPoints;

    public int getNumberOfMutationPoints() {
        return this.numberOfMutationPoints;
    }

    public void setNumberOfMutationPoints(int numberOfMutationPoints) {
        this.numberOfMutationPoints = numberOfMutationPoints;
        this.mutationPoints = new int[numberOfMutationPoints];
    }

    @Override
    public void configure(Configuration configuration) {
        int numberOfMutationPoints = configuration.getInt("[@number-of-mutation-points]");
        this.setNumberOfMutationPoints(numberOfMutationPoints);
    }

    public boolean equals(Object other) {
        if (other instanceof SeveralLociMutator) {
            SeveralLociMutator o = (SeveralLociMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.numberOfMutationPoints, o.numberOfMutationPoints);
            return eb.isEquals();
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append(this.numberOfMutationPoints);
        return tsb.toString();
    }

    @Override
    protected void mutateNext() {
        int gl = this.species.getGenotypeLength();
        IntArrayIndividual mutant = (IntArrayIndividual)this.parentsBuffer.get(this.parentsCounter);
        int[] mgenome = new int[gl];
        System.arraycopy(mutant.getGenotype(), 0, mgenome, 0, gl);
        this.setMpoints();
        int i = 0;
        while (i < this.numberOfMutationPoints) {
            this.flip(mgenome, this.mutationPoints[i]);
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(mgenome));
    }

    private final void setMpoints() {
        int gl = this.species.getGenotypeLength();
        int i = 0;
        while (i < this.numberOfMutationPoints) {
            boolean exit;
            block1: do {
                this.mutationPoints[i] = this.randgen.choose(0, gl);
                exit = true;
                int j = 0;
                while (j < i) {
                    if (this.mutationPoints[i] == this.mutationPoints[j]) {
                        exit = false;
                        continue block1;
                    }
                    ++j;
                }
            } while (!exit);
            ++i;
        }
    }
}

