/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.classifiers.Classifier;
import moa.classifiers.Regressor;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.RegressionMainTask;
import moa.tasks.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearnModelRegression
extends RegressionMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Classifier to train.", Regressor.class, "trees.FIMTDD");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", InstanceStream.class, "generators.RandomTreeGenerator");
    public IntOption maxInstancesOption = new IntOption("maxInstances", 'm', "Maximum number of instances to train on per pass over the data.", 10000000, 0, Integer.MAX_VALUE);
    public IntOption numPassesOption = new IntOption("numPasses", 'p', "The number of passes to do over the data.", 1, 1, Integer.MAX_VALUE);
    public IntOption memCheckFrequencyOption = new IntOption("memCheckFrequency", 'q', "How many instances between memory bound checks.", 100000, 0, Integer.MAX_VALUE);

    @Override
    public String getPurposeString() {
        return "Learns a model from a stream.";
    }

    public LearnModelRegression() {
    }

    public LearnModelRegression(Classifier learner, InstanceStream stream, int maxInstances, int numPasses) {
        this.learnerOption.setCurrentObject(learner);
        this.streamOption.setCurrentObject(stream);
        this.maxInstancesOption.setValue(maxInstances);
        this.numPassesOption.setValue(numPasses);
    }

    @Override
    public Class<?> getTaskResultType() {
        return Regressor.class;
    }

    @Override
    public Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Classifier learner = (Classifier)this.getPreparedClassOption(this.learnerOption);
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        learner.setModelContext(stream.getHeader());
        int numPasses = this.numPassesOption.getValue();
        int maxInstances = this.maxInstancesOption.getValue();
        for (int pass = 0; pass < numPasses; ++pass) {
            long instancesProcessed = 0L;
            monitor.setCurrentActivity("Training learner" + (numPasses > 1 ? " (pass " + (pass + 1) + "/" + numPasses + ")" : "") + "...", -1.0);
            if (pass > 0) {
                stream.restart();
            }
            while (stream.hasMoreInstances() && (maxInstances < 0 || instancesProcessed < (long)maxInstances)) {
                learner.trainOnInstance(stream.nextInstance());
                if (++instancesProcessed % 10L != 0L) continue;
                if (monitor.taskShouldAbort()) {
                    return null;
                }
                long estimatedRemainingInstances = stream.estimatedRemainingInstances();
                if (maxInstances > 0) {
                    long maxRemaining = (long)maxInstances - instancesProcessed;
                    if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                        estimatedRemainingInstances = maxRemaining;
                    }
                }
                monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
                if (!monitor.resultPreviewRequested()) continue;
                monitor.setLatestResultPreview(learner.copy());
            }
        }
        learner.setModelContext(stream.getHeader());
        return learner;
    }
}

