/*
 * Decompiled with CFR 0.152.
 */
package vu.co.kaiyin;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.primitives.Ints;
import com.sun.istack.internal.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import vu.co.kaiyin.GenoBytes;
import vu.co.kaiyin.GenoCodes;
import vu.co.kaiyin.GenoData;
import vu.co.kaiyin.GenoIndex;
import vu.co.kaiyin.ShiftCodes;
import vu.co.kaiyin.Utils;

public class Bed
implements Serializable {
    private final String bedFilename;
    private final String bimFilename;
    private final String famFilename;
    private final int bytesSnp;
    private final int nIndividuals;
    private final int nIndividualsApparent;
    private final long bedSize;
    private final int nSNPs;
    private final byte[] magicBytes;
    private final BiMap<String, Integer> snpIndexMap;
    private String[][] FamilyIndividualID;

    public String[][] getFamilyIndividualID() throws Exception {
        if (this.FamilyIndividualID == null) {
            this.FamilyIndividualID = Utils.readDelimitedFile(new File(this.famFilename), "\\s+", 0, new int[]{0, 1});
        }
        return this.FamilyIndividualID;
    }

    public Bed(String bedFilename, int bytesSnp, int nIndividuals) throws IOException {
        this(bedFilename);
    }

    public Bed(String bedFilename) throws IOException {
        if (!FilenameUtils.getExtension(bedFilename).equals("bed")) {
            throw new InvalidParameterException("bedFilename is not a bed file");
        }
        this.bedFilename = bedFilename;
        this.bimFilename = this.bimFilename(bedFilename);
        this.famFilename = this.famFilename(bedFilename);
        this.magicBytes = new byte[]{108, 27, 1};
        this.nSNPs = Utils.countLines(this.bimFilename);
        this.nIndividuals = Utils.countLines(this.famFilename);
        this.bytesSnp = (int)Math.ceil((double)this.nIndividuals / 4.0);
        this.nIndividualsApparent = this.bytesSnp * 4;
        this.bedSize = new File(bedFilename).length();
        long theoBedSize = (long)this.bytesSnp * (long)this.nSNPs + 3L;
        if (this.bedSize != theoBedSize) {
            throw new InvalidParameterException("bed file size not correct.");
        }
        this.snpIndexMap = HashBiMap.create();
    }

    private void readSnpIndex() throws FileNotFoundException {
        BufferedReader br = new BufferedReader(new FileReader(this.bimFilename));
        try {
            String line = br.readLine();
            int counter = 1;
            while (line != null) {
                String snp = line.split("\\s+", 4)[1];
                this.snpIndexMap.put(snp, new Integer(counter));
                line = br.readLine();
                ++counter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public Integer getSnpIndex(String snp) throws FileNotFoundException {
        if (this.snpIndexMap.isEmpty()) {
            this.readSnpIndex();
        }
        return (Integer)this.snpIndexMap.get(snp);
    }

    @Nullable
    public String getSnpName(int index) throws FileNotFoundException {
        if (this.snpIndexMap.isEmpty()) {
            this.readSnpIndex();
        }
        return (String)this.snpIndexMap.inverse().get(index);
    }

    public GenoIndex getSnpName(int[] index) throws FileNotFoundException {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < index.length; ++i) {
            String name = this.getSnpName(index[i]);
            if (name == null) continue;
            indices.add(index[i]);
            names.add(name);
        }
        return new GenoIndex(indices.stream().mapToInt(Integer::valueOf).toArray(), (String[])names.stream().toArray(String[]::new));
    }

    public GenoIndex getSnpIndex(String[] snp) throws FileNotFoundException {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < snp.length; ++i) {
            Integer idx = this.getSnpIndex(snp[i]);
            if (idx == null) continue;
            indices.add(idx);
            names.add(snp[i]);
        }
        return new GenoIndex(indices.stream().mapToInt(Integer::valueOf).toArray(), (String[])names.stream().toArray(String[]::new));
    }

    public String bimFilename(String filename) {
        return String.format("%s.bim", FilenameUtils.removeExtension(filename));
    }

    public String famFilename(String filename) {
        return String.format("%s.fam", FilenameUtils.removeExtension(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenoData readBed(GenoIndex genoIndex, boolean transpose) throws IOException {
        int j;
        int i;
        int[] snpVec = genoIndex.getIndex();
        String[] snpNames = genoIndex.getNames();
        int nSNPtoRead = snpVec.length;
        int numbers_per_snp = this.bytesSnp * 4;
        int[][] geno = new int[nSNPtoRead][this.nIndividuals];
        int[][] geno_transposed = new int[this.nIndividuals][nSNPtoRead];
        try (RandomAccessFile bedFile = new RandomAccessFile(this.bedFilename, "r");){
            for (i = 0; i < nSNPtoRead; ++i) {
                int n = i;
                snpVec[n] = snpVec[n] - 1;
                byte[] snpBuffer = this.readSnpBytes(bedFile, snpVec[i]);
                for (j = 0; j < this.bytesSnp; ++j) {
                    int[] snp_expanded = (int[])GenoCodes.genotypeCodeMap.get(new Byte(snpBuffer[j]));
                    int k = 4 * j;
                    int m = 0;
                    while (k < 4 * (j + 1) && k < this.nIndividuals) {
                        geno[i][k] = snp_expanded[m];
                        ++k;
                        ++m;
                    }
                }
            }
        }
        if (transpose) {
            for (i = 0; i < nSNPtoRead; ++i) {
                for (j = 0; j < this.nIndividuals; ++j) {
                    geno_transposed[j][i] = geno[i][j];
                }
            }
            return new GenoData(snpNames, geno_transposed, true);
        }
        return new GenoData(snpNames, geno, false);
    }

    public GenoData readBed(int[] snp_vec, boolean transpose) throws IOException {
        return this.readBed(this.getSnpName(snp_vec), transpose);
    }

    public GenoData readBed(int[] snp_vec) throws IOException {
        return this.readBed(snp_vec, true);
    }

    public GenoData readBed() throws IOException {
        return this.readBed(this.getSnpName(Utils.seq(1, this.nSNPs)), true);
    }

    public GenoData readBed(boolean transpose) throws IOException {
        return this.readBed(Utils.seq(1, this.nSNPs), transpose);
    }

    public GenoData readBed(String[] snp_vec, boolean transpose) throws IOException {
        return this.readBed(this.getSnpIndex(snp_vec), transpose);
    }

    public GenoData readBed(String[] snp_vec) throws IOException {
        return this.readBed(snp_vec, true);
    }

    public byte[] readSnpBytes(RandomAccessFile bedFile, int i) throws IOException {
        byte[] snp_buffer = new byte[this.bytesSnp];
        bedFile.seek((long)i * (long)this.bytesSnp + 3L);
        bedFile.readFully(snp_buffer);
        return snp_buffer;
    }

    public byte[] readSnpBytes(InputStream inputStream, int nBytes) throws IOException {
        byte[] buffer = new byte[nBytes];
        inputStream.read(buffer);
        return buffer;
    }

    public byte[] readSnpBytes(InputStream inputStream) throws IOException {
        return this.readSnpBytes(inputStream, this.bytesSnp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyBed(String inputFile, String outFile) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(inputFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(outFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            byte[] bytesBuffer = this.readSnpBytes(bufferedInputStream, 3);
            bufferedOutputStream.write(bytesBuffer);
            for (int i = 0; i < this.nSNPs; ++i) {
                bytesBuffer = this.readSnpBytes(bufferedInputStream);
                bufferedOutputStream.write(bytesBuffer);
            }
        }
        finally {
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        FileUtils.copyFile(new File(this.bimFilename(inputFile)), new File(this.bimFilename(outFile)));
        FileUtils.copyFile(new File(this.famFilename(inputFile)), new File(this.famFilename(outFile)));
    }

    public void copyBed(String outFile) throws IOException {
        this.copyBed(this.bedFilename, outFile);
    }

    public void shift(String inputFile, int nShift) throws IOException {
        this.shift(inputFile, nShift, GenoBytes.defaultCollapseMatrix);
    }

    public void shift(int nShift) throws IOException {
        this.shift(this.bedFilename, nShift, GenoBytes.defaultCollapseMatrix);
    }

    public void shift(int nShift, int[][] collapseMatrix) throws IOException {
        this.shift(this.bedFilename, nShift, collapseMatrix);
    }

    public void shiftBySnpNames(String inputFilename, String outputFilename, String[] snpNames1, String[] snpNames2, int[][] collapseMatrix) throws IOException {
        assert (snpNames1.length == snpNames2.length) : "The two arrays of SNP names should be of the same length";
        int[] snpIdx1 = new int[snpNames1.length];
        int[] snpIdx2 = new int[snpNames2.length];
        for (int i = 0; i < snpNames1.length; ++i) {
            snpIdx1[i] = this.getSnpIndex(snpNames1[i]);
            snpIdx2[i] = this.getSnpIndex(snpNames2[i]);
        }
        this.shiftBySnpIdx(inputFilename, outputFilename, snpIdx1, snpIdx2, collapseMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftBySnpIdx(String inputFilename, String outputFilename, int[] snpIdx1, int[] snpIdx2, int[][] collapseMatrix) throws IOException {
        String outFileBim = FilenameUtils.removeExtension(outputFilename) + ".bim";
        String outFileFam = FilenameUtils.removeExtension(outputFilename) + ".fam";
        if (new File(outputFilename).exists() && new File(outFileBim).exists() && new File(outFileFam).exists()) {
            System.out.printf("From Java, these files already exist: \t\n%s\t\n%s\t\n%s", outputFilename, outFileBim, outFileFam);
            return;
        }
        RandomAccessFile inputRaf = new RandomAccessFile(inputFilename, "r");
        FileOutputStream fileOutputStream = new FileOutputStream(outputFilename);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        ShiftCodes shiftCodes = new ShiftCodes(collapseMatrix);
        try {
            bufferedOutputStream.write(this.magicBytes);
            for (int i = 0; i < snpIdx1.length; ++i) {
                byte[] bytesBuffer = this.readSnpBytes(inputRaf, snpIdx1[i]);
                byte[] bytesBuffer1 = this.readSnpBytes(inputRaf, snpIdx2[i]);
                byte[] bytesCollapsed = shiftCodes.lookup(bytesBuffer, bytesBuffer1);
                bufferedOutputStream.write(bytesCollapsed);
            }
        }
        finally {
            inputRaf.close();
            bufferedOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shift(String inputFilename, int nShift, int[][] collapseMatrix) throws IOException {
        ShiftCodes shiftCodes = new ShiftCodes(collapseMatrix);
        String outFile = Utils.shiftedFilename(inputFilename, nShift);
        String outFileBim = FilenameUtils.removeExtension(outFile) + ".bim";
        String outFileFam = FilenameUtils.removeExtension(outFile) + ".fam";
        if (new File(outFile).exists() && new File(outFileBim).exists() && new File(outFileFam).exists()) {
            System.out.printf("From Java, these files already exist: \t\n%s\t\n%s\t\n%s", outFile, outFileBim, outFileFam);
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(inputFilename);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        FileInputStream fileInputStream1 = new FileInputStream(inputFilename);
        BufferedInputStream bufferedInputStream1 = new BufferedInputStream(fileInputStream1);
        FileOutputStream fileOutputStream = new FileOutputStream(outFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            byte[] bytesBuffer = this.readSnpBytes(bufferedInputStream, 3);
            bufferedOutputStream.write(bytesBuffer);
            this.readSnpBytes(bufferedInputStream1, nShift * this.bytesSnp + 3);
            for (int i = 0; i < this.nSNPs; ++i) {
                byte[] bytesCollapsed;
                bytesBuffer = this.readSnpBytes(bufferedInputStream);
                if (i >= this.nSNPs - nShift) {
                    bytesCollapsed = new byte[this.bytesSnp];
                    Arrays.fill(bytesCollapsed, (byte)85);
                } else {
                    byte[] bytesBuffer1 = this.readSnpBytes(bufferedInputStream1);
                    bytesCollapsed = shiftCodes.lookup(bytesBuffer, bytesBuffer1);
                }
                bufferedOutputStream.write(bytesCollapsed);
            }
        }
        finally {
            bufferedInputStream.close();
            bufferedInputStream1.close();
            bufferedOutputStream.close();
        }
        String bimFilename = this.bimFilename(inputFilename);
        String famFilename = this.famFilename(inputFilename);
        String bimFilenameShifted = Utils.shiftedFilename(bimFilename, nShift);
        String famFilenameShifted = Utils.shiftedFilename(famFilename, nShift);
        try {
            Files.createSymbolicLink(Paths.get(bimFilenameShifted, new String[0]), Paths.get(bimFilename, new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            System.err.println(e);
        }
        try {
            Files.createSymbolicLink(Paths.get(famFilenameShifted, new String[0]), Paths.get(famFilename, new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public String shiftedFilename(int nShift) {
        return Utils.shiftedFilename(this.bedFilename, nShift);
    }

    public OutputStream writeBytes(OutputStream fileStream, byte[] bytes) {
        try {
            fileStream.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileStream;
    }

    public OutputStream writeBytes(OutputStream fileStream) {
        return this.writeBytes(fileStream, this.magicBytes);
    }

    public OutputStream writeBytes(String filename, byte[] bytes) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        BufferedOutputStream fileBufferedOutput = new BufferedOutputStream(fileOutputStream);
        return this.writeBytes(fileBufferedOutput, bytes);
    }

    public OutputStream writeBytes(String filename) throws FileNotFoundException {
        return this.writeBytes(filename, this.magicBytes);
    }

    public String getBedFilename() {
        return this.bedFilename;
    }

    public String getBimFilename() {
        return this.bimFilename;
    }

    public String getFamFilename() {
        return this.famFilename;
    }

    public int getBytesSnp() {
        return this.bytesSnp;
    }

    public int getnIndividuals() {
        return this.nIndividuals;
    }

    public int getnIndividualsApparent() {
        return this.nIndividualsApparent;
    }

    public long getBedSize() {
        return this.bedSize;
    }

    public int getnSNPs() {
        return this.nSNPs;
    }

    public byte[] getMagicBytes() {
        return this.magicBytes;
    }

    public static void main(String[] args) throws IOException {
        String filename = Bed.class.getResource("/test.bed").getFile();
        System.out.println(filename);
        Bed bed = new Bed(filename);
        GenoIndex genoIndex = bed.getSnpIndex(new String[]{"snp432", "snp531", "snp2", "snp1"});
        Ints.asList(genoIndex.getIndex()).stream().forEach(s -> System.out.println(s));
        for (String name : genoIndex.getNames()) {
            System.out.println(name);
        }
    }
}

