## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(declared)

## -----------------------------------------------------------------------------
library(haven)
x1 <- labelled_spss(
  x = c(1:5, -91),
  labels = c("Missing" = -91),
  na_value = -91
)

## -----------------------------------------------------------------------------
x1

## -----------------------------------------------------------------------------
is.na(x1)

## -----------------------------------------------------------------------------
mean(x1)

## -----------------------------------------------------------------------------
library(labelled)
mean(
  user_na_to_na(x1),
  na.rm = TRUE
)

## -----------------------------------------------------------------------------
library(declared)
x2 <- declared(
  x = c(1:5, -91),
  labels = c("Missing" = -91),
  na_value = -91
)
x2

## -----------------------------------------------------------------------------
mean(x2)

## -----------------------------------------------------------------------------
mean(c(x2, NA))
mean(c(x2, NA), na.rm = TRUE)

## -----------------------------------------------------------------------------
is.na(c(x2, NA))

## -----------------------------------------------------------------------------
is.empty(c(x2, NA))

## -----------------------------------------------------------------------------
na.omit(x2)

