/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import opennlp.model.TrainUtil;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EncodingParameter;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.parser.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.parser.treeinsert.Parser;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserTrainerTool
extends AbstractTrainerTool<Parse, TrainerToolParams> {
    public ParserTrainerTool() {
        super(Parse.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trains the learnable parser";
    }

    static Dictionary buildDictionary(ObjectStream<Parse> parseSamples, opennlp.tools.parser.HeadRules headRules, int cutoff) {
        Dictionary mdict;
        System.err.print("Building dictionary ...");
        try {
            mdict = opennlp.tools.parser.chunking.Parser.buildDictionary(parseSamples, headRules, cutoff);
        }
        catch (IOException e) {
            System.err.println("Error while building dictionary: " + e.getMessage());
            mdict = null;
        }
        System.err.println("done");
        return mdict;
    }

    static ParserType parseParserType(String typeAsString) {
        ParserType type = null;
        if (typeAsString != null && typeAsString.length() > 0 && (type = ParserType.parse(typeAsString)) == null) {
            throw new TerminateToolException(1, "ParserType training parameter '" + typeAsString + "' is invalid!");
        }
        return type;
    }

    @Override
    public void run(String format, String[] args) {
        ParserModel model;
        File modelOutFile;
        block19: {
            super.run(format, args);
            this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), true);
            if (this.mlParams != null) {
                if (!TrainUtil.isValid(this.mlParams.getSettings("build"))) {
                    throw new TerminateToolException(1, "Build training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("check"))) {
                    throw new TerminateToolException(1, "Check training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("attach"))) {
                    throw new TerminateToolException(1, "Attach training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("tagger"))) {
                    throw new TerminateToolException(1, "Tagger training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("chunker"))) {
                    throw new TerminateToolException(1, "Chunker training parameters are invalid!");
                }
            }
            if (this.mlParams == null) {
                this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
            }
            modelOutFile = ((TrainerToolParams)this.params).getModel();
            CmdLineUtil.checkOutputFile("parser model", modelOutFile);
            try {
                HeadRules rules = new HeadRules(new InputStreamReader((InputStream)new FileInputStream(((TrainerToolParams)this.params).getHeadRules()), ((TrainerToolParams)this.params).getEncoding()));
                ParserType type = ParserTrainerTool.parseParserType(((TrainerToolParams)this.params).getParserType());
                if (((TrainerToolParams)this.params).getFun().booleanValue()) {
                    Parse.useFunctionTags(true);
                }
                if (ParserType.CHUNKING.equals((Object)type)) {
                    model = opennlp.tools.parser.chunking.Parser.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, rules, this.mlParams);
                    break block19;
                }
                if (ParserType.TREEINSERT.equals((Object)type)) {
                    model = Parser.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, rules, this.mlParams);
                    break block19;
                }
                throw new IllegalStateException();
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
            }
            finally {
                try {
                    this.sampleStream.close();
                }
                catch (IOException e) {}
            }
        }
        CmdLineUtil.writeModel("parser", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams,
    EncodingParameter {
    }
}

