/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.hash.stereo.StereoEncoder;

final class MultiStereoEncoder
implements StereoEncoder {
    private final BitSet unconfigured;
    private final List<StereoEncoder> encoders;

    public MultiStereoEncoder(List<StereoEncoder> encoders) {
        if (encoders.isEmpty()) {
            throw new IllegalArgumentException("no stereo encoders provided");
        }
        this.encoders = Collections.unmodifiableList(new ArrayList<StereoEncoder>(encoders));
        this.unconfigured = new BitSet(encoders.size());
        this.unconfigured.flip(0, encoders.size());
    }

    @Override
    public boolean encode(long[] current, long[] next) {
        boolean configured = false;
        int i = this.unconfigured.nextSetBit(0);
        while (i >= 0) {
            if (this.encoders.get(i).encode(current, next)) {
                this.unconfigured.clear(i);
                configured = true;
            }
            i = this.unconfigured.nextSetBit(i + 1);
        }
        return configured;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.encoders.size(); ++i) {
            this.unconfigured.set(i);
            this.encoders.get(i).reset();
        }
    }
}

