/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ft;

import java.util.Vector;
import weka.classifiers.functions.SimpleLinearRegression;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.BinC45Split;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.Stats;
import weka.classifiers.trees.lmt.LogisticBase;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;

public abstract class FTtree
extends LogisticBase {
    static final long serialVersionUID = 1862737145870398755L;
    protected double m_totalInstanceWeight;
    protected int m_id;
    protected int m_leafModelNum;
    protected int m_minNumInstances;
    protected ModelSelection m_modelSelection;
    protected NominalToBinary m_nominalToBinary;
    protected SimpleLinearRegression[][] m_higherRegressions;
    protected int m_numHigherRegressions = 0;
    protected int m_numInstances;
    protected ClassifierSplitModel m_localModel;
    protected ClassifierSplitModel m_auxLocalModel;
    protected FTtree[] m_sons;
    protected int m_leafclass;
    protected boolean m_isLeaf;
    protected boolean m_hasConstr = true;
    protected double m_constError = 0.0;
    protected float m_CF = 0.1f;

    @Override
    public abstract void buildClassifier(Instances var1) throws Exception;

    public abstract void buildTree(Instances var1, SimpleLinearRegression[][] var2, double var3, double var5) throws Exception;

    public abstract double prune() throws Exception;

    protected Instances insertNewAttr(Instances data) throws Exception {
        int i = 0;
        while (i < data.classAttribute().numValues()) {
            data.insertAttributeAt(new Attribute("N" + i), i);
            ++i;
        }
        return data;
    }

    protected Instances removeExtAttributes(Instances data) throws Exception {
        int i = 0;
        while (i < data.classAttribute().numValues()) {
            data.deleteAttributeAt(0);
            ++i;
        }
        return data;
    }

    protected double getEstimatedErrors() {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(this.m_localModel.distribution());
        }
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.m_sons[i].getEstimatedErrors();
            ++i;
        }
        return errors;
    }

    protected double getEstimatedErrorsForBranch(Instances data) throws Exception {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(new Distribution(data));
        }
        Distribution savedDist = this.m_localModel.distribution();
        this.m_localModel.resetDistribution(data);
        Instances[] localInstances = this.m_localModel.split(data);
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.m_sons[i].getEstimatedErrorsForBranch(localInstances[i]);
            ++i;
        }
        return errors;
    }

    protected double getEstimatedErrorsForDistribution(Distribution theDistribution) {
        if (Utils.eq(theDistribution.total(), 0.0)) {
            return 0.0;
        }
        double numInc = theDistribution.numIncorrect();
        double numTotal = theDistribution.total();
        return (Stats.addErrs(numTotal, numInc, this.m_CF) + numInc) / numTotal;
    }

    protected double getEtimateConstModel(Distribution theDistribution) {
        if (Utils.eq(theDistribution.total(), 0.0)) {
            return 0.0;
        }
        double numTotal = theDistribution.total();
        return (Stats.addErrs(numTotal, this.m_constError, this.m_CF) + this.m_constError) / numTotal;
    }

    public int getNumInnerNodes() {
        if (this.m_isLeaf) {
            return 0;
        }
        int numNodes = 1;
        int i = 0;
        while (i < this.m_sons.length) {
            numNodes += this.m_sons[i].getNumInnerNodes();
            ++i;
        }
        return numNodes;
    }

    public int getNumLeaves() {
        int numLeaves;
        if (!this.m_isLeaf) {
            numLeaves = 0;
            int numEmptyLeaves = 0;
            int i = 0;
            while (i < this.m_sons.length) {
                numLeaves += this.m_sons[i].getNumLeaves();
                if (this.m_sons[i].m_isLeaf && !this.m_sons[i].hasModels()) {
                    ++numEmptyLeaves;
                }
                ++i;
            }
            if (numEmptyLeaves > 1) {
                numLeaves -= numEmptyLeaves - 1;
            }
        } else {
            numLeaves = 1;
        }
        return numLeaves;
    }

    protected SimpleLinearRegression[][] mergeArrays(SimpleLinearRegression[][] a1, SimpleLinearRegression[][] a2) {
        int j;
        int numModels1 = a1[0].length;
        int numModels2 = a2[0].length;
        SimpleLinearRegression[][] result = new SimpleLinearRegression[this.m_numClasses][numModels1 + numModels2];
        int i = 0;
        while (i < this.m_numClasses) {
            j = 0;
            while (j < numModels1) {
                result[i][j] = a1[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numClasses) {
            j = 0;
            while (j < numModels2) {
                result[i][j + numModels1] = a2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Vector getNodes() {
        Vector nodeList = new Vector();
        this.getNodes(nodeList);
        return nodeList;
    }

    public void getNodes(Vector nodeList) {
        if (!this.m_isLeaf) {
            nodeList.add(this);
            int i = 0;
            while (i < this.m_sons.length) {
                this.m_sons[i].getNodes(nodeList);
                ++i;
            }
        }
    }

    @Override
    protected Instances getNumericData(Instances train) throws Exception {
        Instances filteredData = new Instances(train);
        this.m_nominalToBinary = new NominalToBinary();
        this.m_nominalToBinary.setInputFormat(filteredData);
        filteredData = Filter.useFilter(filteredData, this.m_nominalToBinary);
        return super.getNumericData(filteredData);
    }

    @Override
    protected double[] getFs(Instance instance) throws Exception {
        double[] pred = new double[this.m_numClasses];
        double[] instanceFs = super.getFs(instance);
        int i = 0;
        while (i < this.m_numHigherRegressions) {
            double predSum = 0.0;
            int j = 0;
            while (j < this.m_numClasses) {
                pred[j] = this.m_higherRegressions[j][i].classifyInstance(instance);
                predSum += pred[j];
                ++j;
            }
            predSum /= (double)this.m_numClasses;
            j = 0;
            while (j < this.m_numClasses) {
                int n = j;
                instanceFs[n] = instanceFs[n] + (pred[j] - predSum) * (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
                ++j;
            }
            ++i;
        }
        return instanceFs;
    }

    public int getConstError(double[] probsConst) {
        return Utils.maxIndex(probsConst);
    }

    public boolean hasModels() {
        return this.m_numRegressions > 0;
    }

    public double[] modelDistributionForInstance(Instance instance) throws Exception {
        instance = (Instance)instance.copy();
        this.m_nominalToBinary.input(instance);
        instance = this.m_nominalToBinary.output();
        instance.setDataset(this.m_numericDataHeader);
        return this.probs(this.getFs(instance));
    }

    @Override
    public abstract double[] distributionForInstance(Instance var1) throws Exception;

    @Override
    public String toString() {
        this.assignLeafModelNumbers(0);
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_isLeaf && !this.m_hasConstr) {
                text.append(": ");
                text.append("Class=" + this.m_leafclass);
            } else if (this.m_isLeaf && this.m_hasConstr) {
                text.append(": ");
                text.append("FT_" + this.m_leafModelNum + ":" + this.getModelParameters());
            } else {
                this.dumpTree(0, text);
            }
            text.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            text.append("\nSize of the Tree : \t" + this.numNodes() + "\n");
            text.append(this.modelsToString());
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print logistic model tree";
        }
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int numLeaves = 0;
        int i = 0;
        while (i < this.m_sons.length) {
            numLeaves += this.m_sons[i].numLeaves();
            ++i;
        }
        return numLeaves;
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int numNodes = 1;
        int i = 0;
        while (i < this.m_sons.length) {
            numNodes += this.m_sons[i].numNodes();
            ++i;
        }
        return numNodes;
    }

    public String getModelParameters() {
        StringBuffer text = new StringBuffer();
        int numModels = this.m_numRegressions + this.m_numHigherRegressions;
        text.append(String.valueOf(this.m_numRegressions) + "/" + numModels + " (" + this.m_numInstances + ")");
        return text.toString();
    }

    protected void dumpTree(int depth, StringBuffer text) throws Exception {
        int i = 0;
        while (i < this.m_sons.length) {
            text.append("\n");
            int j = 0;
            while (j < depth) {
                text.append("|   ");
                ++j;
            }
            if (this.m_hasConstr) {
                text.append(String.valueOf(this.m_localModel.leftSide(this.m_train)) + "#" + this.m_id);
            } else {
                text.append(this.m_localModel.leftSide(this.m_train));
            }
            text.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf && this.m_sons[i].m_hasConstr) {
                text.append(": ");
                text.append("FT_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters());
            } else if (this.m_sons[i].m_isLeaf && !this.m_sons[i].m_hasConstr) {
                text.append(": ");
                text.append("Class=" + this.m_sons[i].m_leafclass);
            } else {
                this.m_sons[i].dumpTree(depth + 1, text);
            }
            ++i;
        }
    }

    public int assignIDs(int lastID) {
        int currLastID;
        this.m_id = currLastID = lastID + 1;
        if (this.m_sons != null) {
            int i = 0;
            while (i < this.m_sons.length) {
                currLastID = this.m_sons[i].assignIDs(currLastID);
                ++i;
            }
        }
        return currLastID;
    }

    public int assignLeafModelNumbers(int leafCounter) {
        if (!this.m_isLeaf) {
            this.m_leafModelNum = 0;
            int i = 0;
            while (i < this.m_sons.length) {
                leafCounter = this.m_sons[i].assignLeafModelNumbers(leafCounter);
                ++i;
            }
        } else {
            this.m_leafModelNum = ++leafCounter;
        }
        return leafCounter;
    }

    @Override
    protected double[][] getCoefficients() {
        double[][] coefficients = super.getCoefficients();
        double constFactor = (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
        int j = 0;
        while (j < this.m_numClasses) {
            int i = 0;
            while (i < this.m_numHigherRegressions) {
                double slope = this.m_higherRegressions[j][i].getSlope();
                double intercept = this.m_higherRegressions[j][i].getIntercept();
                int attribute = this.m_higherRegressions[j][i].getAttributeIndex();
                double[] dArray = coefficients[j];
                dArray[0] = dArray[0] + constFactor * intercept;
                double[] dArray2 = coefficients[j];
                int n = attribute + 1;
                dArray2[n] = dArray2[n] + constFactor * slope;
                ++i;
            }
            ++j;
        }
        return coefficients;
    }

    public String modelsToString() {
        StringBuffer text = new StringBuffer();
        if (this.m_isLeaf && this.m_hasConstr) {
            text.append("FT_" + this.m_leafModelNum + ":" + super.toString());
        } else if (!this.m_isLeaf && this.m_hasConstr) {
            if (this.m_modelSelection instanceof BinC45ModelSelection) {
                text.append("FT_N" + ((BinC45Split)this.m_localModel).attIndex() + "#" + this.m_id + ":" + super.toString());
            } else {
                text.append("FT_N" + ((C45Split)this.m_localModel).attIndex() + "#" + this.m_id + ":" + super.toString());
            }
            int i = 0;
            while (i < this.m_sons.length) {
                text.append("\n" + this.m_sons[i].modelsToString());
                ++i;
            }
        } else if (!this.m_isLeaf && !this.m_hasConstr) {
            int i = 0;
            while (i < this.m_sons.length) {
                text.append("\n" + this.m_sons[i].modelsToString());
                ++i;
            }
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            text.append("");
        }
        return text.toString();
    }

    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        this.assignIDs(-1);
        this.assignLeafModelNumbers(0);
        text.append("digraph FTree {\n");
        if (this.m_isLeaf && this.m_hasConstr) {
            text.append("N" + this.m_id + " [label=\"FT_" + this.m_leafModelNum + ":" + this.getModelParameters() + "\" " + "shape=box style=filled");
            text.append("]\n");
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            text.append("N" + this.m_id + " [label=\"Class=" + this.m_leafclass + "\" " + "shape=box style=filled");
            text.append("]\n");
        } else {
            text.append("N" + this.m_id + " [label=\"" + this.m_localModel.leftSide(this.m_train) + "\" ");
            text.append("]\n");
            this.graphTree(text);
        }
        return String.valueOf(text.toString()) + "}\n";
    }

    protected void graphTree(StringBuffer text) throws Exception {
        int i = 0;
        while (i < this.m_sons.length) {
            text.append("N" + this.m_id + "->" + "N" + this.m_sons[i].m_id + " [label=\"" + this.m_localModel.rightSide(i, this.m_train).trim() + "\"]\n");
            if (this.m_sons[i].m_isLeaf && this.m_sons[i].m_hasConstr) {
                text.append("N" + this.m_sons[i].m_id + " [label=\"FT_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters() + "\" " + "shape=box style=filled");
                text.append("]\n");
            } else if (this.m_sons[i].m_isLeaf && !this.m_sons[i].m_hasConstr) {
                text.append("N" + this.m_sons[i].m_id + " [label=\"Class=" + this.m_sons[i].m_leafclass + "\" " + "shape=box style=filled");
                text.append("]\n");
            } else {
                text.append("N" + this.m_sons[i].m_id + " [label=\"" + this.m_sons[i].m_localModel.leftSide(this.m_train) + "\" ");
                text.append("]\n");
                this.m_sons[i].graphTree(text);
            }
            ++i;
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (!this.m_isLeaf) {
            int i = 0;
            while (i < this.m_sons.length) {
                this.m_sons[i].cleanup();
                ++i;
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

