/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.FlexibleGrowth;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodelxml.coalescent.demographicmodel.AsymptoticGrowthModelParser;
import dr.inference.model.Parameter;

public class AsymptoticGrowthModel
extends DemographicModel {
    Parameter asyptoteValue = null;
    Parameter shapeParameter = null;
    FlexibleGrowth flexibleGrowth = null;

    public AsymptoticGrowthModel(Parameter parameter, Parameter parameter2, Units.Type type) {
        this(AsymptoticGrowthModelParser.ASYMPTOTIC_GROWTH_MODEL, parameter, parameter2, type);
    }

    public AsymptoticGrowthModel(String string, Parameter parameter, Parameter parameter2, Units.Type type) {
        super(string);
        this.flexibleGrowth = new FlexibleGrowth(type);
        this.asyptoteValue = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.shapeParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        double d = this.asyptoteValue.getParameterValue(0);
        double d2 = this.shapeParameter.getParameterValue(0);
        double d3 = d / d2;
        this.flexibleGrowth.setN0(d3);
        this.flexibleGrowth.setK(d2);
        this.flexibleGrowth.setR(0.0);
        return this.flexibleGrowth;
    }
}

