/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.NormalStatisticsProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.NormalDistribution;

public class IndependentNormalDistributionModel
extends AbstractModelLikelihood
implements NormalStatisticsProvider {
    Parameter mean;
    Parameter variance;
    Parameter precision;
    Parameter data;
    boolean usePrecision;

    public IndependentNormalDistributionModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        super(string);
        this.addVariable(parameter);
        this.mean = parameter;
        if (parameter3 != null) {
            this.usePrecision = true;
            this.addVariable(parameter3);
        } else {
            this.usePrecision = false;
            this.addVariable(parameter2);
        }
        this.precision = parameter3;
        this.variance = parameter2;
        this.data = parameter4;
        this.addVariable(parameter4);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.data.getDimension(); ++i) {
            double d2 = this.usePrecision ? Math.sqrt(1.0 / this.precision.getParameterValue(i)) : Math.sqrt(this.variance.getParameterValue(i));
            d += NormalDistribution.logPdf(this.data.getParameterValue(i), this.mean.getParameterValue(i), d2);
        }
        return d;
    }

    @Override
    public void makeDirty() {
    }

    public boolean precisionUsed() {
        return this.usePrecision;
    }

    public Parameter getPrecision() {
        return this.precision;
    }

    public Parameter getVariance() {
        return this.variance;
    }

    public Parameter getMean() {
        return this.mean;
    }

    public Parameter getData() {
        return this.data;
    }

    @Override
    public double getNormalMean(int n) {
        return this.mean.getParameterValue(n);
    }

    @Override
    public double getNormalSD(int n) {
        if (this.usePrecision) {
            return 1.0 / Math.sqrt(this.precision.getParameterValue(n));
        }
        return Math.sqrt(this.variance.getParameterValue(n));
    }
}

