/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.NormalDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogNormalDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
GradientProvider,
HessianProvider {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return LogNormalDistributionModel.this.pdf(Math.log(d));
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Parameter meanParameter;
    private final Parameter stdevParameter;
    private final Parameter muParameter;
    private final Parameter sigmaParameter;
    private final Parameter precisionParameter;
    private final double offset;
    private Parameterization parameterization;

    public LogNormalDistributionModel(Parameter parameter, Parameter parameter2, double d, boolean bl) {
        super("logNormalDistributionModel");
        this.offset = d;
        if (bl) {
            this.meanParameter = parameter;
            this.muParameter = null;
            this.addVariable(this.meanParameter);
            this.meanParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.stdevParameter = parameter2;
            this.sigmaParameter = null;
            this.addVariable(this.stdevParameter);
            this.stdevParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.parameterization = Parameterization.MEAN_STDEV;
        } else {
            this.muParameter = parameter;
            this.meanParameter = null;
            this.addVariable(this.muParameter);
            this.muParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
            this.sigmaParameter = parameter2;
            this.stdevParameter = null;
            this.addVariable(this.sigmaParameter);
            this.sigmaParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
            this.parameterization = Parameterization.MU_SIGMA;
        }
        this.precisionParameter = null;
    }

    public LogNormalDistributionModel(Parameterization parameterization, Parameter parameter, Parameter parameter2, double d) {
        super("logNormalDistributionModel");
        switch (parameterization) {
            case MU_SIGMA: {
                this.muParameter = parameter;
                this.sigmaParameter = parameter2;
                this.meanParameter = null;
                this.stdevParameter = null;
                this.precisionParameter = null;
                this.parameterization = Parameterization.MU_SIGMA;
                break;
            }
            case MU_PRECISION: {
                this.muParameter = parameter;
                this.precisionParameter = parameter2;
                this.meanParameter = null;
                this.stdevParameter = null;
                this.sigmaParameter = null;
                this.parameterization = Parameterization.MU_PRECISION;
                break;
            }
            case MEAN_STDEV: {
                this.meanParameter = parameter;
                this.stdevParameter = parameter2;
                this.muParameter = null;
                this.sigmaParameter = null;
                this.precisionParameter = null;
                this.parameterization = Parameterization.MEAN_STDEV;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow parameterization type");
            }
        }
        this.offset = d;
        if (this.muParameter != null) {
            this.addVariable(this.muParameter);
            this.muParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        }
        if (this.meanParameter != null) {
            this.addVariable(this.meanParameter);
            this.meanParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        if (this.sigmaParameter != null) {
            this.addVariable(this.sigmaParameter);
            this.sigmaParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        if (this.stdevParameter != null) {
            this.addVariable(this.stdevParameter);
            this.stdevParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        if (this.precisionParameter != null) {
            this.addVariable(this.precisionParameter);
            this.precisionParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
    }

    public Parameter getMeanParameter() {
        return this.meanParameter;
    }

    public Parameter getStdevParameter() {
        return this.stdevParameter;
    }

    public Parameter getMuParameter() {
        return this.muParameter;
    }

    public Parameter getSigmaParameter() {
        return this.sigmaParameter;
    }

    public Parameter getPrecisionParameter() {
        return this.precisionParameter;
    }

    public Parameterization getParameterization() {
        return this.parameterization;
    }

    public final double getMu() {
        if (this.muParameter != null) {
            return (Double)this.muParameter.getValue(0);
        }
        return this.calculateMu((Double)this.meanParameter.getValue(0), (Double)this.stdevParameter.getValue(0));
    }

    public final double getMean() {
        if (this.meanParameter != null) {
            return (Double)this.meanParameter.getValue(0);
        }
        return this.calculateMean((Double)this.muParameter.getValue(0), this.getSigma());
    }

    public final double getSigma() {
        if (this.sigmaParameter != null) {
            return (Double)this.sigmaParameter.getValue(0);
        }
        if (this.precisionParameter != null) {
            return Math.sqrt(1.0 / (Double)this.precisionParameter.getValue(0));
        }
        return this.calculateSigma((Double)this.meanParameter.getValue(0), (Double)this.stdevParameter.getValue(0));
    }

    public final double getStdev() {
        if (this.stdevParameter != null) {
            return (Double)this.stdevParameter.getValue(0);
        }
        if (this.precisionParameter != null) {
            double d = Math.sqrt(1.0 / (Double)this.precisionParameter.getValue(0));
            return this.calculateStdev((Double)this.muParameter.getValue(0), d);
        }
        return this.calculateStdev((Double)this.muParameter.getValue(0), (Double)this.sigmaParameter.getValue(0));
    }

    public final double getPrecision() {
        if (this.precisionParameter != null) {
            return (Double)this.precisionParameter.getValue(0);
        }
        double d = this.getSigma();
        return 1.0 / (d * d);
    }

    private double calculateMu(double d, double d2) {
        return Math.log(d / Math.sqrt(1.0 + d2 * d2 / (d * d)));
    }

    private double calculateSigma(double d, double d2) {
        return Math.sqrt(Math.log(1.0 + d2 * d2 / (d * d)));
    }

    private double calculateMean(double d, double d2) {
        return Math.exp(d + 0.5 * d2 * d2);
    }

    private double calculateStdev(double d, double d2) {
        return Math.sqrt((Math.exp(d2 * d2) - 1.0) * Math.exp(2.0 * d + d2 * d2));
    }

    @Override
    public double pdf(double d) {
        if (d - this.offset <= 0.0) {
            return 0.0;
        }
        return NormalDistribution.pdf(Math.log(d - this.offset), this.getMu(), this.getSigma()) / (d - this.offset);
    }

    @Override
    public double logPdf(double d) {
        if (d - this.offset <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = NormalDistribution.logPdf(Math.log(d - this.offset), this.getMu(), this.getSigma()) - Math.log(d - this.offset);
        return d2;
    }

    @Override
    public double cdf(double d) {
        if (d - this.offset <= 0.0) {
            return 0.0;
        }
        return NormalDistribution.cdf(Math.log(d - this.offset), this.getMu(), this.getSigma());
    }

    @Override
    public double quantile(double d) {
        return Math.exp(NormalDistribution.quantile(d, this.getMu(), this.getSigma())) + this.offset;
    }

    @Override
    public double mean() {
        return this.getMean();
    }

    @Override
    public double variance() {
        return this.getStdev() * this.getStdev();
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        return this.getDerivativeLogDensity(object, DerivativeType.HESSIAN);
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        double[] dArray = this.getDiagonalHessianLogDensity(object);
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][i] = dArray[i];
        }
        return dArray2;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.getDerivativeLogDensity(object, DerivativeType.GRADIENT);
    }

    private double[] getDerivativeLogDensity(Object object, DerivativeType derivativeType) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = derivativeType.getDerivativeLogPdf(dArray[i], this.getMu(), this.getSigma());
        }
        return dArray2;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.meanParameter;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    public static void main(String[] stringArray) {
        Parameter.Default default_ = new Parameter.Default(1.0);
        Parameter.Default default_2 = new Parameter.Default(5.0);
        Parameter.Default default_3 = new Parameter.Default(-1.629048);
        Parameter.Default default_4 = new Parameter.Default(1.80502);
        LogNormalDistributionModel logNormalDistributionModel = new LogNormalDistributionModel(Parameterization.MEAN_STDEV, (Parameter)default_, default_2, 0.0);
        System.out.println("Lognormal mean = 1.0, stdev = 5.0");
        System.out.println("  mu = " + logNormalDistributionModel.getMu() + " (correct = -1.629048)");
        System.out.println("  sigma = " + logNormalDistributionModel.getSigma() + " (correct = 1.80502)");
        System.out.println("  quantile(2.5) = " + logNormalDistributionModel.quantile(0.025) + " (correct = 0.005702663)");
        System.out.println("  quantile(97.5) = " + logNormalDistributionModel.quantile(0.975) + " (correct = 6.744487892)");
        LogNormalDistributionModel logNormalDistributionModel2 = new LogNormalDistributionModel(Parameterization.MU_SIGMA, (Parameter)default_3, default_4, 0.0);
        System.out.println("Lognormal mu = -1.629048, sigma = 1.80502");
        System.out.println("  mean = " + logNormalDistributionModel2.getMean() + " (correct = 1.0)");
        System.out.println("  sigma = " + logNormalDistributionModel2.getStdev() + " (correct = 5.0)");
        System.out.println("  quantile(2.5) = " + logNormalDistributionModel2.quantile(0.025) + " (correct = 0.005702663)");
        System.out.println("  quantile(97.5) = " + logNormalDistributionModel2.quantile(0.975) + " (correct = 6.744487892)");
        default_ = new Parameter.Default(0.001);
        default_2 = new Parameter.Default(5.0E-4);
        LogNormalDistributionModel logNormalDistributionModel3 = new LogNormalDistributionModel(Parameterization.MEAN_STDEV, (Parameter)default_, default_2, 0.0);
        System.out.println("Lognormal mean = 0.001, stdev = 0.0005");
        System.out.println("  mu = " + logNormalDistributionModel3.getMu());
        System.out.println("  sigma = " + logNormalDistributionModel3.getSigma());
        for (int i = 1; i <= 12; ++i) {
            double d = (double)i / 13.0;
            System.out.println(i + "\t" + d + "\t" + logNormalDistributionModel3.quantile(d));
        }
    }

    private static enum DerivativeType {
        GRADIENT("gradient"){

            @Override
            public double getDerivativeLogPdf(double d, double d2, double d3) {
                return (NormalDistribution.gradLogPdf(Math.log(d), d2, d3) - 1.0) / d;
            }
        }
        ,
        HESSIAN("hessian"){

            @Override
            public double getDerivativeLogPdf(double d, double d2, double d3) {
                double d4 = Math.log(d);
                return (NormalDistribution.hessianLogPdf(d4, d2, d3) - NormalDistribution.gradLogPdf(d4, d2, d3) + 1.0) / (d * d);
            }
        };

        private String type;

        private DerivativeType(String string2) {
            this.type = string2;
        }

        public abstract double getDerivativeLogPdf(double var1, double var3, double var5);
    }

    public static enum Parameterization {
        MU_SIGMA,
        MU_PRECISION,
        MEAN_STDEV;

    }
}

