/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import CADStat.java.plots.SubsetFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.neptuneinc.cadstat.plots.ConditionalProbability;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class ScatterPlot
extends DataPlotDialog {
    private JCheckBox confIntCheck;
    private JLabel confLabel;
    private JSpinner confLevelSpinner;
    private JCheckBox loessLineCheck;
    private JPanel plotLabelsPane;
    private JPanel plotOptionsPane;
    private JPanel plotPane;
    private JTextField plotTitle;
    private JLabel plotTitleLabel;
    private JCheckBox predIntCheck;
    private JCheckBox regLineCheck;
    private JPanel topPane;
    private JPanel varPane;
    private JTextField xAxis;
    private JLabel xAxisLabel;
    private JComboBox xComboBox;
    private JLabel xLabel;
    private JTextField yAxis;
    private JLabel yAxisLabel;
    private JComboBox yComboBox;
    private JLabel yLabel;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScatterPlot.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.getDatasetPane().refreshDatasetComboBox();
        this.getPlotPane().add((Component)this.plotPane, "Center");
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshSubmitButtonValidity();
    }

    public void refreshVariableListValidity() {
        this.xComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.xComboBox.getItemCount() > 0);
        this.yComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.yComboBox.getItemCount() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = null;
            try {
                nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
                this.xComboBox.setModel(new DefaultComboBoxModel(nonFactors));
                this.yComboBox.setModel(new DefaultComboBoxModel(nonFactors));
                if (this.xComboBox.getItemCount() > 0) {
                    this.xComboBox.setSelectedIndex(0);
                }
                if (this.yComboBox.getItemCount() > 0) {
                    this.yComboBox.setSelectedIndex(0);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(ScatterPlot.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(ScatterPlot.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.xComboBox.removeAllItems();
            this.yComboBox.removeAllItems();
        }
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.xComboBox.getItemCount() > 0 && this.yComboBox.getItemCount() > 0);
    }

    public void refreshConfPredInt() {
        this.confIntCheck.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
        this.predIntCheck.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
        if (!this.regLineCheck.isSelected() && !this.loessLineCheck.isSelected()) {
            this.confIntCheck.setSelected(false);
            this.predIntCheck.setSelected(false);
        }
        this.confLabel.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
        this.confLevelSpinner.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.topPane = new JPanel();
        this.varPane = new JPanel();
        this.xLabel = new JLabel();
        this.xComboBox = new JComboBox();
        this.yLabel = new JLabel();
        this.yComboBox = new JComboBox();
        this.plotLabelsPane = new JPanel();
        this.plotTitleLabel = new JLabel();
        this.plotTitle = new JTextField();
        this.xAxisLabel = new JLabel();
        this.xAxis = new JTextField();
        this.yAxisLabel = new JLabel();
        this.yAxis = new JTextField();
        this.plotOptionsPane = new JPanel();
        this.regLineCheck = new JCheckBox();
        this.loessLineCheck = new JCheckBox();
        this.predIntCheck = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevelSpinner = new JSpinner();
        this.confIntCheck = new JCheckBox();
        this.topPane.setLayout(new GridLayout(1, 2));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.xLabel.setText("X");
        this.yLabel.setText("Y");
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xLabel).addComponent(this.yLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.yComboBox, 0, 293, Short.MAX_VALUE).addComponent(this.xComboBox, 0, 293, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xComboBox, -2, -1, -2).addComponent(this.xLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yComboBox, -2, -1, -2).addComponent(this.yLabel)).addContainerGap(50, Short.MAX_VALUE)));
        this.topPane.add(this.varPane);
        this.plotLabelsPane.setBorder(BorderFactory.createTitledBorder("Plot Labels"));
        this.plotTitleLabel.setHorizontalAlignment(4);
        this.plotTitleLabel.setLabelFor(this.plotTitle);
        this.plotTitleLabel.setText("Plot Title");
        this.plotTitle.setColumns(12);
        this.plotTitle.setText("Scatterplot");
        this.xAxisLabel.setHorizontalAlignment(4);
        this.xAxisLabel.setLabelFor(this.xAxis);
        this.xAxisLabel.setText("X-Axis");
        this.xAxis.setColumns(12);
        this.xAxis.setText("X");
        this.yAxisLabel.setHorizontalAlignment(4);
        this.yAxisLabel.setLabelFor(this.yAxis);
        this.yAxisLabel.setText("Y-Axis");
        this.yAxis.setColumns(12);
        this.yAxis.setText("Y");
        GroupLayout plotLabelsPaneLayout = new GroupLayout(this.plotLabelsPane);
        this.plotLabelsPane.setLayout(plotLabelsPaneLayout);
        plotLabelsPaneLayout.setHorizontalGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotLabelsPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.xAxisLabel).addComponent(this.plotTitleLabel).addComponent(this.yAxisLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xAxis, -1, 226, Short.MAX_VALUE).addComponent(this.plotTitle, -1, 226, Short.MAX_VALUE).addComponent(this.yAxis, -1, 226, Short.MAX_VALUE)).addContainerGap()));
        plotLabelsPaneLayout.setVerticalGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotLabelsPaneLayout.createSequentialGroup().addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.plotTitleLabel).addComponent(this.plotTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xAxis, -2, -1, -2).addComponent(this.xAxisLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yAxis, -2, -1, -2).addComponent(this.yAxisLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.topPane.add(this.plotLabelsPane);
        this.plotOptionsPane.setBorder(BorderFactory.createTitledBorder("Plot Options"));
        this.regLineCheck.setText("Linear Regression Line");
        this.regLineCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScatterPlot.this.regLineCheckActionPerformed(evt);
            }
        });
        this.loessLineCheck.setText("Loess Smooth");
        this.loessLineCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScatterPlot.this.loessLineCheckActionPerformed(evt);
            }
        });
        this.predIntCheck.setText("Add Prediction Intervals");
        this.predIntCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.predIntCheck.setEnabled(false);
        this.confLabel.setText("Confidence / Prediction Level");
        this.confLabel.setEnabled(false);
        this.confLevelSpinner.setModel(new SpinnerNumberModel(0.95, 0.5, 0.99, 0.01));
        this.confLevelSpinner.setEnabled(false);
        this.confIntCheck.setText("Add Confidence Intervals");
        this.confIntCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.confIntCheck.setEnabled(false);
        GroupLayout plotOptionsPaneLayout = new GroupLayout(this.plotOptionsPane);
        this.plotOptionsPane.setLayout(plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, plotOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.regLineCheck).addComponent(this.loessLineCheck)).addGap(30, 30, 30).addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptionsPaneLayout.createSequentialGroup().addComponent(this.confIntCheck).addContainerGap()).addGroup(plotOptionsPaneLayout.createSequentialGroup().addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptionsPaneLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.confLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.confLevelSpinner, -2, -1, -2)).addComponent(this.predIntCheck)).addGap(77, 77, 77)))));
        plotOptionsPaneLayout.setVerticalGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptionsPaneLayout.createSequentialGroup().addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regLineCheck).addComponent(this.confIntCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loessLineCheck).addComponent(this.predIntCheck, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confLabel, -2, 17, -2).addComponent(this.confLevelSpinner, -2, -1, -2)).addContainerGap()));
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topPane, GroupLayout.Alignment.TRAILING, -1, 708, Short.MAX_VALUE).addComponent(this.plotOptionsPane, GroupLayout.Alignment.TRAILING, -1, 708, Short.MAX_VALUE)).addContainerGap()));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addComponent(this.topPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotOptionsPane, -2, -1, -2)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 511) / 2, 800, 511);
    }

    private void regLineCheckActionPerformed(ActionEvent evt) {
        this.refreshConfPredInt();
    }

    private void loessLineCheckActionPerformed(ActionEvent evt) {
        this.refreshConfPredInt();
    }

    @Override
    protected void submitButtonAction() {
        PreferencesManager prefsManager = new PreferencesManager();
        try {
            prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(ConditionalProbability.class.getName()).log(Level.INFO, null, ex);
        }
        String cmd = "scatterplot2.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane1().getSelectedFactorValues())) + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane2().getSelectedFactorValues())) + ", x='" + GUIUtils.getSelectedItem(this.xComboBox) + "', y='" + GUIUtils.getSelectedItem(this.yComboBox) + "', main='" + this.plotTitle.getText() + "', xlab='" + this.xAxis.getText() + "', ylab='" + this.yAxis.getText() + "', add.lm=" + String.valueOf(this.regLineCheck.isSelected()).toUpperCase() + ", add.loess=" + String.valueOf(this.loessLineCheck.isSelected()).toUpperCase() + ", add.conf=" + String.valueOf(this.confIntCheck.isSelected()).toUpperCase() + ", add.pred=" + String.valueOf(this.predIntCheck.isSelected()).toUpperCase() + ", conf=" + (Double)this.confLevelSpinner.getValue() + ", " + prefsManager.getCadstatPreferences().toString() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('scatterplot.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object currX = this.xComboBox.getSelectedItem();
        Object currY = this.yComboBox.getSelectedItem();
        this.getDatasetPane().refreshDatasetComboBox();
        this.xComboBox.setSelectedItem(currX);
        this.yComboBox.setSelectedItem(currY);
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }
}

