/*
 * Decompiled with CFR 0.152.
 */
package core.stats.scorer;

import core.model.DecomposableModel;
import core.model.GraphAction;
import core.model.ScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.scorer.GraphActionScorer;

public class GraphActionScorerEntropy
extends GraphActionScorer {
    int nbInstances;
    EntropyComputer entropyComputer;
    int maxK;
    boolean normaliseByNumberParameters;

    public GraphActionScorerEntropy(EntropyComputer entropyComputer, int maxK) {
        this.entropyComputer = entropyComputer;
        this.nbInstances = entropyComputer.getNbInstances();
        this.maxK = maxK;
        this.normaliseByNumberParameters = false;
    }

    public GraphActionScorerEntropy(EntropyComputer entropyComputer, int maxK, boolean normalizeByNumberParameters) {
        this.entropyComputer = entropyComputer;
        this.nbInstances = entropyComputer.getNbInstances();
        this.maxK = maxK;
        this.normaliseByNumberParameters = normalizeByNumberParameters;
    }

    @Override
    public ScoredGraphAction scoreEdge(DecomposableModel model, GraphAction action) {
        Double score;
        int treeWidthIfAdding = model.treeWidthIfAdding(action.getV1(), action.getV2());
        if (treeWidthIfAdding > this.maxK) {
            score = Double.POSITIVE_INFINITY;
        } else if (this.normaliseByNumberParameters) {
            long dfDiff = model.nbParametersDiffIfAdding(action.getV1(), action.getV2());
            score = (double)dfDiff / model.entropyDiffIfAdding(action.getV1(), action.getV2(), this.entropyComputer);
        } else {
            score = 1.0 / model.entropyDiffIfAdding(action.getV1(), action.getV2(), this.entropyComputer);
        }
        ScoredGraphAction scoredAction = new ScoredGraphAction(action.getType(), action.getV1(), action.getV2(), score);
        return scoredAction;
    }
}

