/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import org.jgrapht.Graph;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.jgrapht.experimental.equivalence.EquivalenceComparatorChainBase;
import org.jgrapht.experimental.isomorphism.EquivalenceIsomorphismInspector;
import org.jgrapht.experimental.isomorphism.GraphIsomorphismInspector;
import org.jgrapht.experimental.isomorphism.VertexDegreeEquivalenceComparator;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.Multigraph;
import org.jgrapht.graph.Pseudograph;

public class AdaptiveIsomorphismInspectorFactory {
    public static final int GRAPH_TYPE_ARBITRARY = 0;
    public static final int GRAPH_TYPE_PLANAR = 1;
    public static final int GRAPH_TYPE_TREE = 2;
    public static final int GRAPH_TYPE_MULTIGRAPH = 3;

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspector(Graph<V, E> graph, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> equivalenceComparator, EquivalenceComparator<E, Graph<V, E>> equivalenceComparator2) {
        int n = AdaptiveIsomorphismInspectorFactory.checkGraphsType(graph, graph2);
        return AdaptiveIsomorphismInspectorFactory.createAppropriateConcreteInspector(n, graph, graph2, equivalenceComparator, equivalenceComparator2);
    }

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspector(Graph<V, E> graph, Graph<V, E> graph2) {
        return AdaptiveIsomorphismInspectorFactory.createIsomorphismInspector(graph, graph2, null, null);
    }

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspectorByType(int n, Graph<V, E> graph, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> equivalenceComparator, EquivalenceComparator<E, Graph<V, E>> equivalenceComparator2) {
        return AdaptiveIsomorphismInspectorFactory.createAppropriateConcreteInspector(n, graph, graph2, equivalenceComparator, equivalenceComparator2);
    }

    public static <V, E> GraphIsomorphismInspector createIsomorphismInspectorByType(int n, Graph<V, E> graph, Graph<V, E> graph2) {
        return AdaptiveIsomorphismInspectorFactory.createAppropriateConcreteInspector(n, graph, graph2, null, null);
    }

    protected static <V, E> GraphIsomorphismInspector createAppropriateConcreteInspector(int n, Graph<V, E> graph, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> equivalenceComparator, EquivalenceComparator<E, Graph<V, E>> equivalenceComparator2) {
        AdaptiveIsomorphismInspectorFactory.assertUnsupportedGraphTypes(graph);
        AdaptiveIsomorphismInspectorFactory.assertUnsupportedGraphTypes(graph2);
        GraphIsomorphismInspector graphIsomorphismInspector = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                graphIsomorphismInspector = AdaptiveIsomorphismInspectorFactory.createTopologicalExhaustiveInspector(graph, graph2, equivalenceComparator, equivalenceComparator2);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type was not one of the supported types.");
            }
        }
        return graphIsomorphismInspector;
    }

    protected static void assertUnsupportedGraphTypes(Graph graph) throws IllegalArgumentException {
        if (graph instanceof Multigraph || graph instanceof DirectedMultigraph || graph instanceof Pseudograph) {
            throw new IllegalArgumentException("graph type not supported for the graph" + graph);
        }
    }

    protected static int checkGraphsType(Graph graph, Graph graph2) {
        return 0;
    }

    protected static <V, E> GraphIsomorphismInspector createTopologicalExhaustiveInspector(Graph<V, E> graph, Graph<V, E> graph2, EquivalenceComparator<V, Graph<V, E>> equivalenceComparator, EquivalenceComparator<E, Graph<V, E>> equivalenceComparator2) {
        VertexDegreeEquivalenceComparator vertexDegreeEquivalenceComparator = new VertexDegreeEquivalenceComparator();
        EquivalenceComparatorChainBase equivalenceComparatorChainBase = new EquivalenceComparatorChainBase(vertexDegreeEquivalenceComparator);
        equivalenceComparatorChainBase.appendComparator(equivalenceComparator);
        EquivalenceIsomorphismInspector<V, E> equivalenceIsomorphismInspector = new EquivalenceIsomorphismInspector<V, E>(graph, graph2, equivalenceComparatorChainBase, equivalenceComparator2);
        return equivalenceIsomorphismInspector;
    }
}

