/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.Aes;
import org.rosuda.deducer.plots.AesWidget;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.Template;
import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class TemplateView
extends ElementView {
    protected JScrollPane scroller;
    protected JPanel paramPanel;
    protected Template model;
    protected VariableSelectorWidget selector;
    protected Vector widgets = new Vector();

    public TemplateView() {
        this.initGui();
    }

    public TemplateView(Template template) {
        this.initGui();
        this.setModel(template);
    }

    private void initGui() {
        this.paramPanel = new JPanel();
        this.scroller = new JScrollPane();
        this.scroller.setViewportView(this.paramPanel);
        this.scroller.setHorizontalScrollBarPolicy(31);
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.scroller.setBorder(border);
        if (this.selector == null) {
            this.selector = new VariableSelectorWidget();
            this.selector.setPreferredSize(new Dimension(150, 300));
            this.selector.setCopyMode(true);
        }
        this.removeAll();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.add((Component)this.scroller, new AnchorConstraint(60, 1000, 1000, 160, 2, 1, 1, 2));
        this.add((Component)this.selector, new AnchorConstraint(20, 90, 1000, 10, 2, 0, 1, 2));
    }

    public void updatePanel() {
        JPanel jPanel;
        Object object;
        int n;
        this.paramPanel.removeAll();
        BoxLayout boxLayout = new BoxLayout(this.paramPanel, 1);
        this.paramPanel.setLayout(boxLayout);
        for (n = 0; n < this.model.getAess().size(); ++n) {
            object = (Aes)this.model.getAess().get(n);
            jPanel = new AesWidget();
            ((AesWidget)jPanel).setVariableSelector(this.selector);
            ((AesWidget)jPanel).setModel((Aes)object);
            ((AesWidget)jPanel).setShowToggle(false);
            jPanel.setAlignmentX(0.5f);
            jPanel.setMaximumSize(new Dimension(365, jPanel.getMaximumSize().height));
            ((AesWidget)jPanel).setCalculatedVariables(((Template.MaskingAes)this.model.getMAess().get((int)n)).generated);
            this.widgets.add(jPanel);
            this.paramPanel.add(jPanel);
            this.paramPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        for (n = 0; n < this.model.getParams().size(); ++n) {
            object = (Param)this.model.getParams().get(n);
            jPanel = ((Param)object).requiresVariableSelector() ? ((Param)object).getView(this.selector) : ((Param)object).getView();
            jPanel.setAlignmentX(0.5f);
            jPanel.setMaximumSize(new Dimension(365, jPanel.getMaximumSize().height));
            this.widgets.add(jPanel);
            this.paramPanel.add(jPanel);
            this.paramPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        this.paramPanel.validate();
        this.paramPanel.repaint();
    }

    public ElementModel getModel() {
        this.updateModel();
        return this.model;
    }

    public void setModel(Template template) {
        this.model = template;
        if (this.selector.getSelectedData() == null || !this.selector.getSelectedData().equals(this.model.getData()) && this.model.getData() != null) {
            this.selector.setSelectedData(this.model.getData());
        }
        this.updatePanel();
    }

    public void updateModel() {
        this.model.setData(this.selector.getSelectedData());
        for (int i = 0; i < this.widgets.size(); ++i) {
            Object e = this.widgets.get(i);
            if (e instanceof AesWidget) {
                ((AesWidget)e).updateModel();
                continue;
            }
            if (!(e instanceof ParamWidget)) continue;
            ((ParamWidget)e).updateModel();
        }
        this.model.updateElementModels();
    }

    public void setModel(ElementModel elementModel) {
        this.setModel((Template)elementModel);
    }
}

