/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix1DProcedure;
import cern.colt.matrix.tlong.algo.LongFormatter;
import cern.colt.matrix.tlong.algo.LongProperty;
import cern.colt.matrix.tlong.algo.LongSorting;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected LongMatrix2D() {
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(LongMatrix2D.this.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < LongMatrix2D.this.columns; ++j) {
                                l = longLongFunction.apply(l, longFunction.apply(LongMatrix2D.this.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    l = longLongFunction.apply(l, longFunction.apply(this.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, final LongProcedure longProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = LongMatrix2D.this.getQuick(n3, 0);
                        long l2 = 0L;
                        if (longProcedure.apply(l)) {
                            l2 = longLongFunction.apply(l2, longFunction.apply(l));
                        }
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < LongMatrix2D.this.columns; ++j) {
                                l = LongMatrix2D.this.getQuick(i, j);
                                if (!longProcedure.apply(l)) continue;
                                l2 = longLongFunction.apply(l2, longFunction.apply(l));
                            }
                            n = 0;
                        }
                        return l2;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            long l2 = this.getQuick(0, 0);
            if (longProcedure.apply(l2)) {
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    l2 = this.getQuick(i, j);
                    if (!longProcedure.apply(l2)) continue;
                    l = longLongFunction.apply(l, longFunction.apply(l2));
                }
                n5 = 0;
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(LongMatrix2D.this.getQuick(nArray[n4], nArray2[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            long l2 = LongMatrix2D.this.getQuick(nArray[i], nArray2[i]);
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.getQuick(nArray[0], nArray2[0]));
            for (int i = 1; i < n; ++i) {
                long l2 = this.getQuick(nArray[i], nArray2[i]);
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
        }
        return l;
    }

    public long aggregate(final LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction, final LongLongFunction longLongFunction2) {
        this.checkShape(longMatrix2D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longLongFunction2.apply(LongMatrix2D.this.getQuick(n3, 0), longMatrix2D.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < LongMatrix2D.this.columns; ++j) {
                                l = longLongFunction.apply(l, longLongFunction2.apply(LongMatrix2D.this.getQuick(i, j), longMatrix2D.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longLongFunction2.apply(this.getQuick(0, 0), longMatrix2D.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    l = longLongFunction.apply(l, longLongFunction2.apply(this.getQuick(i, j), longMatrix2D.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return l;
    }

    public LongMatrix2D assign(final LongFunction longFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                LongMatrix2D.this.setQuick(i, j, longFunction.apply(LongMatrix2D.this.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, longFunction.apply(this.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure longProcedure, final LongFunction longFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                long l = LongMatrix2D.this.getQuick(i, j);
                                if (!longProcedure.apply(l)) continue;
                                LongMatrix2D.this.setQuick(i, j, longFunction.apply(l));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    long l = this.getQuick(i, j);
                    if (!longProcedure.apply(l)) continue;
                    this.setQuick(i, j, longFunction.apply(l));
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure longProcedure, final long l) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                long l2 = LongMatrix2D.this.getQuick(i, j);
                                if (!longProcedure.apply(l2)) continue;
                                LongMatrix2D.this.setQuick(i, j, l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    long l2 = this.getQuick(i, j);
                    if (!longProcedure.apply(l2)) continue;
                    this.setQuick(i, j, l);
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long l) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                LongMatrix2D.this.setQuick(i, j, l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, l);
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[] lArray) {
        if (lArray.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + lArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * LongMatrix2D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                LongMatrix2D.this.setQuick(i, j, lArray[n++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, lArray[n5++]);
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final int[] nArray) {
        if (nArray.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * LongMatrix2D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                LongMatrix2D.this.setQuick(i, j, nArray[n++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, nArray[n5++]);
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[][] lArray) {
        if (lArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + lArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            long[] lArray2 = lArray[i];
                            if (lArray2.length != LongMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + LongMatrix2D.this.columns());
                            }
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                LongMatrix2D.this.setQuick(i, j, lArray2[j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                long[] lArray2 = lArray[i];
                if (lArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + this.columns());
                }
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, lArray2[j]);
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D) {
        if (longMatrix2D == this) {
            return this;
        }
        this.checkShape(longMatrix2D);
        final LongMatrix2D longMatrix2D2 = this.haveSharedCells(longMatrix2D) ? longMatrix2D.copy() : longMatrix2D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                LongMatrix2D.this.setQuick(i, j, longMatrix2D2.getQuick(i, j));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, longMatrix2D2.getQuick(i, j));
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction) {
        this.checkShape(longMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                LongMatrix2D.this.setQuick(i, j, longLongFunction.apply(LongMatrix2D.this.getQuick(i, j), longMatrix2D.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, longLongFunction.apply(this.getQuick(i, j), longMatrix2D.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(longMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            LongMatrix2D.this.setQuick(nArray[i], nArray2[i], longLongFunction.apply(LongMatrix2D.this.getQuick(nArray[i], nArray2[i]), longMatrix2D.getQuick(nArray[i], nArray2[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], longLongFunction.apply(this.getQuick(nArray[i], nArray2[i]), longMatrix2D.getQuick(nArray[i], nArray2[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                if (LongMatrix2D.this.getQuick(i, j) == 0L) continue;
                                ++n;
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (this.getQuick(i, j) == 0L) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public LongMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(long l) {
        return LongProperty.DEFAULT.equals(this, l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LongMatrix2D)) {
            return false;
        }
        return LongProperty.DEFAULT.equals(this, (LongMatrix2D)object);
    }

    public LongMatrix2D forEachNonZero(final IntIntLongFunction intIntLongFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                long l;
                                long l2 = LongMatrix2D.this.getQuick(i, j);
                                if (l2 == 0L || (l = intIntLongFunction.apply(i, j, l2)) == l2) continue;
                                LongMatrix2D.this.setQuick(i, j, l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    long l;
                    long l2 = this.getQuick(i, j);
                    if (l2 == 0L || (l = intIntLongFunction.apply(i, j, l2)) == l2) continue;
                    this.setQuick(i, j, l);
                }
            }
        }
        return this;
    }

    public long get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    protected LongMatrix2D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                long l = this.getQuick(i, j);
                if (l >= 0L) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                longArrayList.add(l);
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                long l = this.getQuick(i, j);
                if (l == 0L) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                longArrayList.add(l);
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                long l = this.getQuick(i, j);
                if (l <= 0L) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                longArrayList.add(l);
            }
        }
    }

    public abstract long getQuick(int var1, int var2);

    protected boolean haveSharedCells(LongMatrix2D longMatrix2D) {
        if (longMatrix2D == null) {
            return false;
        }
        if (this == longMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(longMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D longMatrix2D) {
        return false;
    }

    public LongMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract LongMatrix2D like(int var1, int var2);

    public abstract LongMatrix1D like1D(int var1);

    protected abstract LongMatrix1D like1D(int var1, int var2, int var3);

    public long[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, this.rows);
            Future[] futureArray = new Future[n3];
            long[][] lArray = new long[n3][2];
            int n5 = this.rows / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n6;
                        int n2 = 0;
                        long l = LongMatrix2D.this.getQuick(n, 0);
                        int n3 = 1;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = n3; j < LongMatrix2D.this.columns; ++j) {
                                long l2 = LongMatrix2D.this.getQuick(i, j);
                                if (l >= l2) continue;
                                l = l2;
                                n = i;
                                n2 = j;
                            }
                            n3 = 0;
                        }
                        return new long[]{l, n, n2};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    lArray[n4] = (long[])futureArray[n4].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (l >= lArray[n4][0]) continue;
                    l = lArray[n4][0];
                    n = (int)lArray[n4][1];
                    n2 = (int)lArray[n4][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.getQuick(0, 0);
            int n8 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n8; j < this.columns; ++j) {
                    long l2 = this.getQuick(i, j);
                    if (l >= l2) continue;
                    l = l2;
                    n = i;
                    n2 = j;
                }
                n8 = 0;
            }
        }
        return new long[]{l, n, n2};
    }

    public long[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, this.rows);
            Future[] futureArray = new Future[n3];
            long[][] lArray = new long[n3][2];
            int n5 = this.rows / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n6;
                        int n2 = 0;
                        long l = LongMatrix2D.this.getQuick(n, 0);
                        int n3 = 1;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = n3; j < LongMatrix2D.this.columns; ++j) {
                                long l2 = LongMatrix2D.this.getQuick(i, j);
                                if (l <= l2) continue;
                                l = l2;
                                n = i;
                                n2 = j;
                            }
                            n3 = 0;
                        }
                        return new long[]{l, n, n2};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    lArray[n4] = (long[])futureArray[n4].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (l <= lArray[n4][0]) continue;
                    l = lArray[n4][0];
                    n = (int)lArray[n4][1];
                    n2 = (int)lArray[n4][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.getQuick(0, 0);
            int n8 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n8; j < this.columns; ++j) {
                    long l2 = this.getQuick(i, j);
                    if (l <= l2) continue;
                    l = l2;
                    n = i;
                    n2 = j;
                }
                n8 = 0;
            }
        }
        return new long[]{l, n, n2};
    }

    public void set(int n, int n2, long l) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, l);
    }

    public abstract void setQuick(int var1, int var2, long var3);

    public long[][] toArray() {
        final long[][] lArray = new long[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            long[] lArray2 = lArray[i];
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                lArray2[j] = LongMatrix2D.this.getQuick(i, j);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                long[] lArray2 = lArray[i];
                for (int j = 0; j < this.columns; ++j) {
                    lArray2[j] = this.getQuick(i, j);
                }
            }
        }
        return lArray;
    }

    public String toString() {
        return new LongFormatter().toString(this);
    }

    public abstract LongMatrix1D vectorize();

    protected LongMatrix2D view() {
        return (LongMatrix2D)this.clone();
    }

    public LongMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = (int)this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public LongMatrix2D viewColumnFlip() {
        return (LongMatrix2D)this.view().vColumnFlip();
    }

    public LongMatrix2D viewDice() {
        return (LongMatrix2D)this.view().vDice();
    }

    public LongMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (LongMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public LongMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = (int)this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public LongMatrix2D viewRowFlip() {
        return (LongMatrix2D)this.view().vRowFlip();
    }

    public LongMatrix2D viewSelection(LongMatrix1DProcedure longMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!longMatrix1DProcedure.apply(this.viewRow(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    public LongMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray2[n2] = n2;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = this._rowOffset(this._rowRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray2[n]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public LongMatrix2D viewSelection(Set<int[]> set) {
        int n;
        int[] nArray4;
        int n2 = set.size();
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int[] nArray4 : set) {
            nArray2[n3] = nArray4[0];
            nArray3[n3] = nArray4[1];
            ++n3;
        }
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        Object object = new int[nArray2.length];
        nArray4 = new int[nArray3.length];
        for (n = 0; n < nArray2.length; ++n) {
            object[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike((int[])object, nArray4);
    }

    protected abstract LongMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public LongMatrix2D viewSorted(int n) {
        return LongSorting.mergeSort.sort(this, n);
    }

    public LongMatrix2D viewStrides(int n, int n2) {
        return (LongMatrix2D)this.view().vStrides(n, n2);
    }

    public LongMatrix1D zMult(LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2) {
        return this.zMult(longMatrix1D, longMatrix1D2, 1L, longMatrix1D2 == null ? 1 : 0, false);
    }

    public LongMatrix1D zMult(final LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2, final long l, final long l2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(longMatrix1D, longMatrix1D2, l, l2, false);
        }
        final LongMatrix1D longMatrix1D3 = longMatrix1D2 == null ? new DenseLongMatrix1D(this.rows) : longMatrix1D2;
        if ((long)this.columns != longMatrix1D.size() || (long)this.rows > longMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + longMatrix1D.toStringShort() + ", " + longMatrix1D3.toStringShort());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = 0;
                            for (int j = 0; j < LongMatrix2D.this.columns; ++j) {
                                n = (int)((long)n + LongMatrix2D.this.getQuick(i, j) * longMatrix1D.getQuick(j));
                            }
                            longMatrix1D3.setQuick(i, l * (long)n + l2 * longMatrix1D3.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                int n5 = 0;
                for (int j = 0; j < this.columns; ++j) {
                    n5 = (int)((long)n5 + this.getQuick(i, j) * longMatrix1D.getQuick(j));
                }
                longMatrix1D3.setQuick(i, l * (long)n5 + l2 * longMatrix1D3.getQuick(i));
            }
        }
        return longMatrix1D3;
    }

    public LongMatrix2D zMult(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2) {
        return this.zMult(longMatrix2D, longMatrix2D2, 1L, longMatrix2D2 == null ? 1 : 0, false, false);
    }

    public LongMatrix2D zMult(final LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2, final long l, final long l2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(longMatrix2D, longMatrix2D2, l, l2, false, bl2);
        }
        if (bl2) {
            return this.zMult(longMatrix2D.viewDice(), longMatrix2D2, l, l2, bl, false);
        }
        final int n = this.rows;
        final int n2 = this.columns;
        int n3 = longMatrix2D.columns;
        final LongMatrix2D longMatrix2D3 = longMatrix2D2 == null ? new DenseLongMatrix2D(n, n3) : longMatrix2D2;
        if (longMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + longMatrix2D.toStringShort());
        }
        if (longMatrix2D3.rows != n || longMatrix2D3.columns != n3) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + longMatrix2D.toStringShort() + ", " + longMatrix2D3.toStringShort());
        }
        if (this == longMatrix2D3 || longMatrix2D == longMatrix2D3) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, n3);
            Future[] futureArray = new Future[n4];
            int n5 = n3 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n3 : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n; ++j) {
                                int n3 = 0;
                                for (int k = 0; k < n2; ++k) {
                                    n3 = (int)((long)n3 + LongMatrix2D.this.getQuick(j, k) * longMatrix2D.getQuick(k, i));
                                }
                                longMatrix2D3.setQuick(j, i, l * (long)n3 + l2 * longMatrix2D3.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    long l3 = 0L;
                    for (int k = 0; k < n2; ++k) {
                        l3 += this.getQuick(j, k) * longMatrix2D.getQuick(k, i);
                    }
                    longMatrix2D3.setQuick(j, i, l * l3 + l2 * longMatrix2D3.getQuick(j, i));
                }
            }
        }
        return longMatrix2D3;
    }

    public long zSum() {
        if (this.size() == 0L) {
            return 0L;
        }
        return this.aggregate(LongFunctions.plus, LongFunctions.identity);
    }
}

