/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.toolkit.WinListener;
import org.rosuda.util.Global;

public class Common {
    public static final int AT_KOH = 32;
    public static final int AT_Framework = 48;
    public static final int NM_MarkerChange = 4096;
    public static final int NM_SecMarkerChange = 4098;
    public static final int NM_AxisChange = 8192;
    public static final int NM_AxisGeometryChange = 8193;
    public static final int NM_AxisDataChange = 8194;
    public static final int NM_VarChange = 12288;
    public static final int NM_VarContentChange = 12289;
    public static final int NM_VarTypeChange = 12290;
    public static final int NM_VarSeqChange = 12291;
    public static final int NM_VarSetChange = 16384;
    public static final int NM_NodeChange = 20480;
    public static final int NM_CatSeqChange = 24576;
    public static final int NM_PrefsChanged = 28672;
    public static final int NM_BREAK = 0x700000;
    public static final int NM_ExtEvent = 0x800000;
    public static final int NM_ActionEvent = 0x800001;
    public static final int NM_MASK = 0xFFF000;
    public static String Version = "1.00";
    public static String Release = "D729";
    public static String appName = "default";
    public static boolean useSwing = true;
    public static boolean startRserv = false;
    public static Dimension screenRes = null;
    public static Color backgroundColor = new Color(255, 255, 192);
    public static Color popupColor = new Color(245, 255, 255);
    public static Color aquaBgColor = new Color(230, 230, 240);
    public static Color selectColor = new Color(255, 0, 0);
    public static Color objectsColor = new Color(255, 255, 255);
    public static boolean noIntVar = false;
    public static Font defaultFont = new Font("SansSerif", 0, 10);
    public static boolean supportsBREAK = false;
    public static Notifier breakDispatcher = null;
    public static Cursor cur_arrow;
    public static Cursor cur_query;
    public static Cursor cur_tick;
    public static Cursor cur_hand;
    public static Cursor cur_zoom;
    public static Cursor cur_move;
    public static Cursor cur_aim;
    public static Frame mainFrame;
    public static double displayGamma;
    static StringBuffer warnings;
    static int warningsCount;
    static int maxWarnings;
    static WindowListener defWinListener;
    static Frame workFrame;

    public static WindowListener getDefaultWindowListener() {
        if (defWinListener == null) {
            defWinListener = new WinListener();
        }
        return defWinListener;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac os");
    }

    public static int getSelectMode(MouseEvent ev) {
        return ev.isShiftDown() ? (ev.isControlDown() || ev.isAltDown() ? 2 : 1) : 0;
    }

    public static void printEvent(MouseEvent ev) {
        if (Global.DEBUG > 0) {
            String mods = "";
            if (ev.isShiftDown()) {
                mods = mods + " SHIFT";
            }
            if (ev.isAltDown()) {
                mods = mods + " ALT";
            }
            if (ev.isControlDown()) {
                mods = mods + " CTRL";
            }
            if (ev.isMetaDown()) {
                mods = mods + " META";
            }
            if (ev.isAltGraphDown()) {
                mods = mods + " ALT.GR";
            }
            if ((ev.getModifiers() & 0x10) == 16) {
                mods = mods + " M1";
            }
            if ((ev.getModifiers() & 8) == 8) {
                mods = mods + " M2";
            }
            if ((ev.getModifiers() & 4) == 4) {
                mods = mods + " M3";
            }
            if (ev.isPopupTrigger()) {
                mods = mods + " POPUP";
            }
            System.out.println("Event:" + ev + mods);
        }
    }

    public static void addWarning(String war) {
        if (maxWarnings > 0 && warningsCount == maxWarnings) {
            warnings.append("** Too many warnings. No further warnings will be recoreded. **");
            ++warningsCount;
        }
        if (maxWarnings > 0 && warningsCount > maxWarnings) {
            return;
        }
        if (warnings == null) {
            warnings = new StringBuffer(war);
        } else {
            warnings.append(war);
        }
        warnings.append("\n");
        ++warningsCount;
    }

    public static String getWarnings() {
        return warnings == null ? null : warnings.toString();
    }

    public static void flushWarnings() {
        warnings = null;
        warningsCount = 0;
    }

    public static String getTriGraph(String s) {
        int i;
        if (s.length() < 4) {
            return s;
        }
        int caps = 0;
        int nums = 0;
        int lzs = 0;
        boolean firstNonZeroNum = false;
        boolean isLz = true;
        StringBuffer cp = new StringBuffer("");
        StringBuffer nm = new StringBuffer("");
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                ++caps;
                cp.append(c);
            }
            if (c > '0' && c <= '9') {
                isLz = false;
            }
            if (!isLz && c >= '0' && c <= '9') {
                ++nums;
                nm.append(c);
            }
            if (c != '0' || !isLz) continue;
            ++lzs;
        }
        if (nums == 1) {
            nums = 2;
            nm = new StringBuffer("0" + nm.toString());
        }
        char lc = s.charAt(s.length() - 1);
        if (nums > 0) {
            if (nums < 3 && s.length() > 4 && s.charAt(1) == '_' && s.charAt(2) == 'i' && s.charAt(3) == '_') {
                return s.charAt(0) + "i" + nm.toString();
            }
            if (caps + nums < 5 && caps > 0) {
                return cp.toString() + nm.toString();
            }
            if (nums < 4 && caps > 0) {
                return cp.toString().substring(0, 4 - nums) + nm.toString();
            }
            if (nums > 1 && nums < 4 && caps == 0 && s.charAt(0) > '9') {
                return s.charAt(0) + nm.toString();
            }
            if (nums == 1 && s.charAt(0) > '9' && s.charAt(s.length() - 1) > '9') {
                return s.charAt(0) + nm.toString() + s.charAt(s.length() - 1);
            }
            if (nums == 1 && s.charAt(0) > '9') {
                lc = nm.toString().charAt(0);
            }
        }
        if (caps == 3 || caps == 4) {
            return cp.toString();
        }
        if (caps == 2 && (lc < 'A' || lc > 'Z')) {
            return cp.append(lc).toString();
        }
        char mid = ' ';
        String ignore = "aeiouAEIOU ._\t\n\r\u00e4\u00f6\u00fc\u00c4\u00dc\u00d6";
        for (i = 1; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (ignore.indexOf(c) != -1) continue;
            mid = c;
            break;
        }
        if (mid == ' ') {
            mid = s.charAt(1);
        }
        return "" + s.charAt(0) + mid + lc;
    }

    public static Dimension getScreenRes() {
        if (screenRes == null) {
            screenRes = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return screenRes;
    }

    public static void beginWorking(String txt) {
        if (workFrame != null) {
            Common.endWorking();
        }
        workFrame = new Frame();
        workFrame.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void endWorking() {
        if (workFrame != null) {
            workFrame.dispose();
            workFrame = null;
        }
    }

    public static double gammaAdjust(double u) {
        return u > 0.00304 ? 1.055 * Math.pow(u, 1.0 / displayGamma) - 0.055 : 12.92 * u;
    }

    public static Color getHCLcolor(double hue, double chroma, double luminance) {
        double XN = 95.047;
        double YN = 100.0;
        double ZN = 108.883;
        double tmp = XN + YN + ZN;
        double xN = XN / tmp;
        double yN = YN / tmp;
        double uN = 2.0 * xN / (6.0 * yN - xN + 1.5);
        double vN = 4.5 * yN / (6.0 * yN - xN + 1.5);
        double U = chroma * Math.cos(Math.PI / 180 * hue);
        double V = chroma * Math.sin(Math.PI / 180 * hue);
        double Y = YN * (luminance > 7.999592 ? Math.pow((luminance + 16.0) / 116.0, 3.0) : luminance / 903.3);
        double u = U / (13.0 * luminance) + uN;
        double v = V / (13.0 * luminance) + vN;
        double X = 9.0 * Y * u / (4.0 * v);
        double Z = -X / 3.0 - 5.0 * Y + 3.0 * Y / v;
        int r = (int)(255.0 * Common.gammaAdjust((3.240479 * X - 1.53715 * Y - 0.498535 * Z) / YN));
        int g = (int)(255.0 * Common.gammaAdjust((-0.969256 * X + 1.875992 * Y + 0.041556 * Z) / YN));
        int b = (int)(255.0 * Common.gammaAdjust((0.055648 * X - 0.204043 * Y + 1.057311 * Z) / YN));
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public static Color getHCLcolor(double hue) {
        return Common.getHCLcolor(hue, 35.0, 85.0);
    }

    public static Color getHCLcolor(double hue, double chroma) {
        return Common.getHCLcolor(hue, chroma, 85.0);
    }

    static {
        displayGamma = 2.2;
        warnings = null;
        warningsCount = 0;
        maxWarnings = 250;
        defWinListener = null;
    }
}

