/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Stopwatch;

public class SVarFact
extends SVar {
    public int[] cont;
    public String[] cats;
    public boolean muteNotify = false;
    int[] temp;
    String[] tempcats;
    int[] ccnts;
    int[] ranks = null;
    boolean lastIsMissing = false;

    public SVarFact(String name, int len) {
        super(name, true);
        this.isnum = false;
        this.cont = new int[len];
        for (int i = 0; i < this.cont.length; ++i) {
            this.cont[i] = this.getCatIndex("NA");
        }
        this.cats = new String[0];
    }

    public SVarFact(String Name, int[] ids, String[] cnames) {
        super(Name, true);
        this.isnum = false;
        this.contentsType = 0;
        this.cont = ids;
        this.cats = cnames;
        this.ccnts = new int[cnames.length + 1];
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] >= 0 && ids[i] < this.cats.length) {
                int n = ids[i];
                this.ccnts[n] = this.ccnts[n] + 1;
                continue;
            }
            this.cont[i] = -1;
            ++this.missingCount;
        }
    }

    public boolean isLastMissing() {
        return this.lastIsMissing;
    }

    public boolean replaceAll(int[] ids, String[] cnames) {
        this.cont = ids;
        this.cats = cnames;
        this.ccnts = new int[cnames.length + 1];
        this.missingCount = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] >= 0 && ids[i] < this.cats.length) {
                int n = ids[i];
                this.ccnts[n] = this.ccnts[n] + 1;
                continue;
            }
            this.cont[i] = -1;
            ++this.missingCount;
        }
        return true;
    }

    public void createMissingsCat() {
        if (!this.cat || this.cont == null || this.cont.length < 1 || this.missingCount == 0 || this.isLastMissing()) {
            return;
        }
        int cvtdMissings = 0;
        for (int j = 0; j < this.cont.length; ++j) {
            if (this.cont[j] != -1) continue;
            this.cont[j] = this.cats.length;
            ++cvtdMissings;
        }
        String[] newcat = new String[this.cats.length + 1];
        System.arraycopy(this.cats, 0, newcat, 0, this.cats.length);
        newcat[this.cats.length] = "NA";
        int[] newcnts = new int[this.cats.length + 1];
        System.arraycopy(this.ccnts, 0, newcnts, 0, this.ccnts.length);
        newcnts[this.cats.length] = cvtdMissings;
        this.missingCount = cvtdMissings;
        this.cats = newcat;
        this.ccnts = newcnts;
        this.lastIsMissing = true;
    }

    @Override
    public void setAllEmpty(int size) {
        this.cont = new int[size];
        for (int i = 0; i < size; ++i) {
            this.cont[i] = -1;
        }
        this.missingCount = size;
    }

    @Override
    public int size() {
        return this.cont.length;
    }

    @Override
    public void categorize(boolean rebuild) {
        if (this.cat && !rebuild) {
            return;
        }
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12290));
        }
    }

    @Override
    public void sortCategories(int method) {
        if (!this.isCat() || this.cats.length < 2) {
            return;
        }
    }

    @Override
    public void dropCat() {
        this.cat = false;
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12290));
        }
    }

    @Override
    public void setCategorical(boolean nc) {
        this.cat = true;
    }

    @Override
    public boolean add(Object o) {
        return false;
    }

    @Override
    public boolean remove(int index) {
        int length = this.size();
        this.temp = new int[--length];
        try {
            int i = 0;
            for (int z = 0; z < this.cont.length && i < this.temp.length; ++i, ++z) {
                if (i == index) {
                    ++z;
                }
                this.temp[i] = this.cont[z];
            }
            this.cont = this.temp;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean insert(Object o, int index) {
        int length = this.size();
        this.temp = new int[++length];
        try {
            int z;
            int i = 0;
            for (z = 0; z < this.cont.length && i < this.temp.length; ++i, ++z) {
                if (i == index) {
                    --z;
                    continue;
                }
                this.temp[i] = this.cont[z];
            }
            this.cont = this.temp;
            if (o == null) {
                this.cont[index] = this.getCatIndex("NA");
            } else {
                int catI = this.getCatIndex(o.toString());
                if (catI == -1) {
                    this.tempcats = new String[this.cats.length + 1];
                    for (z = 0; z < this.cats.length; ++z) {
                        this.tempcats[z] = this.cats[z];
                    }
                    this.tempcats[this.tempcats.length - 1] = o.toString();
                    this.cats = this.tempcats;
                    catI = this.getCatIndex(o.toString());
                }
                this.cont[index] = this.getCatIndex(o.toString());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean replace(int i, Object o) {
        int catI = this.getCatIndex(o.toString());
        if (catI == -1) {
            this.tempcats = new String[this.cats.length + 1];
            for (int z = 0; z < this.cats.length; ++z) {
                this.tempcats[z] = this.cats[z];
            }
            try {
                this.tempcats[this.tempcats.length - 1] = o.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cats = this.tempcats;
            catI = this.getCatIndex(o.toString());
        }
        this.cont[i] = catI;
        return false;
    }

    @Override
    public Object at(int i) {
        return i < 0 || i >= this.cont.length || this.cont[i] < 0 || this.cont[i] > this.cats.length ? null : this.cats[this.cont[i]];
    }

    @Override
    public int atI(int i) {
        return i < 0 || i >= this.cont.length || this.cont[i] < 0 || this.cont[i] > this.cats.length ? -1 : this.cont[i];
    }

    @Override
    public int getCatIndex(Object o) {
        if (this.cats == null || "NA".equals(o)) {
            return -1;
        }
        for (int i = 0; i < this.cats.length; ++i) {
            if (!this.cats[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getCatIndex(int i) {
        return i < 0 || i >= this.cont.length || this.cont[i] < 0 || this.cont[i] >= this.cats.length ? -1 : this.cont[i];
    }

    @Override
    public Object getCatAt(int i) {
        return i < 0 || i >= this.cats.length ? "NA" : this.cats[i];
    }

    @Override
    public int getSizeCatAt(int i) {
        if (this.cats == null) {
            return -1;
        }
        if (i == -1) {
            return this.missingCount;
        }
        return i < 0 || i >= this.cats.length ? -1 : this.ccnts[i];
    }

    @Override
    public int getSizeCat(Object o) {
        if (o == null || o.equals("NA")) {
            return this.missingCount;
        }
        int ci = this.getCatIndex(o);
        return ci < 0 || ci >= this.cats.length ? -1 : this.ccnts[ci];
    }

    @Override
    public int getNumCats() {
        if (this.cats == null) {
            return 0;
        }
        return this.cats.length;
    }

    @Override
    public Object[] getCategories() {
        return this.cats;
    }

    @Override
    public int[] getRanked(SMarker m, int markspec) {
        Stopwatch sw = new Stopwatch();
        if (m == null && this.cacheRanks && this.ranks != null) {
            return this.ranks;
        }
        int[] r = null;
        if (!this.cacheRanks || this.ranks == null) {
            int i;
            int ct = this.size();
            if (ct == 0) {
                return null;
            }
            r = new int[ct];
            for (i = 0; i < ct; ++i) {
                r[i] = i;
            }
            sw.profile("getRanked: prepare");
            for (i = 0; i < ct - 1; ++i) {
                int d = this.cont[r[i]];
                for (int j = ct - 1; j > i; --j) {
                    int d2 = this.cont[r[j]];
                    if (d2 >= d) continue;
                    int xx = r[i];
                    r[i] = r[j];
                    r[j] = xx;
                    d = d2;
                }
            }
            sw.profile("getRanked: sort");
            if (this.cacheRanks) {
                this.ranks = r;
            }
        } else {
            r = this.ranks;
        }
        if (m != null && r != null) {
            int i;
            int x = r.length;
            int ct = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(i) != markspec) continue;
                ++ct;
            }
            if (ct == 0) {
                return null;
            }
            int[] mr = new int[ct];
            int mri = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(r[i]) != markspec) continue;
                mr[mri++] = r[i];
            }
            r = null;
            r = mr;
        }
        return r;
    }

    public boolean hasEqualContents(int[] i2, String[] s2) {
        int i;
        if (i2.length != this.cont.length || s2.length != this.cats.length) {
            return false;
        }
        for (i = 0; i < i2.length; ++i) {
            if (i2[i] == this.cont[i]) continue;
            return false;
        }
        for (i = 0; i < s2.length; ++i) {
            if (!(s2[i] == null && this.cats[i] != null || s2[i] != null && this.cats[i] == null) && (s2[i] == null || this.cats[i] == null || s2[i].equals(this.cats[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "SVarFact(\"" + this.name + "\"," + (this.cat ? "cat," : "cont,") + (this.isnum ? "num," : "txt,") + "n=" + this.size() + ",miss=" + this.missingCount + ")";
    }
}

