/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import uk.ac.rhul.cs.cl1.AbstractNodeSetMerger;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.ClusterONEException;
import uk.ac.rhul.cs.cl1.GreedyClusterGrowthProcess;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.NullTaskMonitor;
import uk.ac.rhul.cs.cl1.QualityFunction;
import uk.ac.rhul.cs.cl1.TaskMonitor;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ValuedNodeSetList;
import uk.ac.rhul.cs.cl1.filters.DensityFilter;
import uk.ac.rhul.cs.cl1.filters.FilterChain;
import uk.ac.rhul.cs.cl1.filters.FluffingFilter;
import uk.ac.rhul.cs.cl1.filters.HaircutFilter;
import uk.ac.rhul.cs.cl1.filters.KCoreFilter;
import uk.ac.rhul.cs.cl1.filters.SizeFilter;
import uk.ac.rhul.cs.cl1.seeding.SeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphAlgorithm;
import uk.ac.rhul.cs.graph.TransitivityCalculator;
import uk.ac.rhul.cs.utils.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterONE
extends GraphAlgorithm
implements Callable<Void> {
    public static final String applicationName = "ClusterONE";
    public static final String version = "1.0";
    private static Executor threadPool = null;
    protected ValuedNodeSetList result = null;
    protected ClusterONEAlgorithmParameters parameters = null;
    protected TaskMonitor monitor = new NullTaskMonitor();
    protected static boolean runningOnMac = false;

    public ClusterONE() {
        this((ClusterONEAlgorithmParameters)null);
    }

    public ClusterONE(ClusterONEAlgorithmParameters algorithmParameters) {
        if (algorithmParameters == null) {
            this.setParameters(new ClusterONEAlgorithmParameters());
        } else {
            this.setParameters(algorithmParameters);
        }
    }

    @Override
    public Void call() throws ClusterONEException {
        this.run();
        return null;
    }

    public ClusterONEAlgorithmParameters getParameters() {
        return this.parameters;
    }

    public List<ValuedNodeSet> getResults() {
        return this.result;
    }

    public static Executor getThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newSingleThreadExecutor();
        }
        return threadPool;
    }

    public static boolean isRunningOnMac() {
        return runningOnMac;
    }

    public void run() throws ClusterONEException {
        AbstractNodeSetMerger merger;
        Double minDensity = this.parameters.getMinDensity();
        ValuedNodeSetList result = new ValuedNodeSetList();
        HashSet<ValuedNodeSet> addedNodeSets = new HashSet<ValuedNodeSet>();
        if (ArrayUtils.min(this.graph.getEdgeWeights()) < 0.0) {
            throw new ClusterONEException("Edge weights must all be non-negative");
        }
        try {
            merger = AbstractNodeSetMerger.fromString(this.parameters.getMergingMethodName());
        }
        catch (InstantiationException ex) {
            throw new ClusterONEException(ex.getMessage());
        }
        if (minDensity == null) {
            TransitivityCalculator calc;
            minDensity = this.graph.isWeighted() ? Double.valueOf(0.3) : ((calc = new TransitivityCalculator(this.graph)).getGlobalTransitivity() < 0.1 ? Double.valueOf(0.6) : Double.valueOf(0.5));
        }
        SeedGenerator seedGenerator = this.parameters.getSeedGenerator();
        seedGenerator.setGraph(this.graph);
        QualityFunction qualityFunc = this.parameters.getQualityFunction();
        FilterChain postFilters = new FilterChain();
        if (this.parameters.getHaircutThreshold() > 0.0) {
            postFilters.add(new HaircutFilter(this.parameters.getHaircutThreshold(), true));
        }
        if (this.parameters.isFluffClusters()) {
            postFilters.add(new FluffingFilter());
        }
        postFilters.add(new SizeFilter(this.parameters.getMinSize()));
        postFilters.add(new DensityFilter(minDensity));
        if (this.parameters.getKCoreThreshold() > 0) {
            postFilters.add(new KCoreFilter(this.parameters.getKCoreThreshold()));
        }
        this.monitor.setStatus("Growing clusters from seeds...");
        this.monitor.setPercentCompleted(0);
        SeedIterator it = seedGenerator.iterator();
        while (it.hasNext()) {
            MutableNodeSet cluster = (MutableNodeSet)it.next();
            if (cluster == null) {
                this.halt();
                return;
            }
            GreedyClusterGrowthProcess growthProcess = new GreedyClusterGrowthProcess(cluster, minDensity, qualityFunc);
            if (this.debugMode) {
                growthProcess.setDebugMode(this.debugMode);
            }
            while (!this.shouldStop && growthProcess.step()) {
            }
            if (this.shouldStop) {
                return;
            }
            if (!postFilters.filter(cluster)) continue;
            ValuedNodeSet frozenCluster = new ValuedNodeSet(cluster, 1);
            cluster = null;
            if (!addedNodeSets.contains(frozenCluster)) {
                result.add(frozenCluster);
                addedNodeSets.add(frozenCluster);
                it.processFoundCluster(frozenCluster);
            }
            this.monitor.setPercentCompleted((int)it.getPercentCompleted());
        }
        this.monitor.setPercentCompleted(100);
        addedNodeSets.clear();
        addedNodeSets = null;
        merger.setTaskMonitor(this.monitor);
        this.result = merger.mergeOverlapping(result, this.parameters.getSimilarityFunction(), this.parameters.getOverlapThreshold());
    }

    public void runOnGraph(Graph graph) throws ClusterONEException {
        this.setGraph(graph);
        this.run();
    }

    public void setParameters(ClusterONEAlgorithmParameters parameters) {
        this.parameters = parameters;
    }

    public void setTaskMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    static {
        runningOnMac = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }
}

