/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class KernelDensityGen
extends RandomVariateGen {
    protected RandomVariateGen kernelGen;
    protected double bandwidth;
    protected boolean positive;

    public KernelDensityGen(RandomStream randomStream, EmpiricalDist empiricalDist, RandomVariateGen randomVariateGen, double d) {
        super(randomStream, empiricalDist);
        if (d < 0.0) {
            throw new IllegalArgumentException("h < 0");
        }
        if (randomVariateGen == null) {
            throw new IllegalArgumentException("kGen == null");
        }
        this.kernelGen = randomVariateGen;
        this.bandwidth = d;
    }

    public KernelDensityGen(RandomStream randomStream, EmpiricalDist empiricalDist, NormalGen normalGen) {
        this(randomStream, empiricalDist, normalGen, 0.77639 * KernelDensityGen.getBaseBandwidth(empiricalDist));
    }

    public static double getBaseBandwidth(EmpiricalDist empiricalDist) {
        double d = empiricalDist.getInterQuartileRange() / 1.34;
        double d2 = empiricalDist.getSampleStandardDeviation();
        if (d2 < d) {
            d = d2;
        }
        return 1.36374 * d / Math.exp(0.2 * Math.log(empiricalDist.getN()));
    }

    public void setBandwidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("h < 0");
        }
        this.bandwidth = d;
    }

    public void setPositiveReflection(boolean bl) {
        this.positive = bl;
    }

    public double nextDouble() {
        double d = this.dist.inverseF(this.stream.nextDouble()) + this.bandwidth * this.kernelGen.nextDouble();
        if (this.positive) {
            return Math.abs(d);
        }
        return d;
    }
}

