/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IReadDataBlock;
import java.text.DecimalFormat;

public class ReadDataBlock
implements IReadDataBlock {
    private final double[] m_data;
    private final int m_start;
    private final int m_end;

    public ReadDataBlock(double[] data) {
        this.m_data = data;
        this.m_start = 0;
        this.m_end = data == null ? 0 : data.length;
    }

    public ReadDataBlock(double[] data, int start, int length) {
        this.m_data = data;
        this.m_start = start;
        this.m_end = start + length;
    }

    @Override
    public void copyTo(double[] buffer, int start) {
        if (this.m_data != null) {
            System.arraycopy(this.m_data, this.m_start, buffer, start, this.m_end - this.m_start);
        }
    }

    @Override
    public double get(int idx) {
        return this.m_data[this.m_start + idx];
    }

    @Override
    public int getLength() {
        return this.m_end - this.m_start;
    }

    @Override
    public IReadDataBlock rextract(int start, int length) {
        return new ReadDataBlock(this.m_data, this.m_start + start, length);
    }

    public String toString() {
        return ReadDataBlock.toString(this);
    }

    public static String toString(IReadDataBlock rd) {
        StringBuilder builder = new StringBuilder();
        int n = rd.getLength();
        if (n > 0) {
            builder.append(rd.get(0));
            for (int i = 1; i < n; ++i) {
                builder.append('\t').append(rd.get(i));
            }
        }
        return builder.toString();
    }

    public static String toString(IReadDataBlock rd, String fmt) {
        StringBuilder builder = new StringBuilder();
        int n = rd.getLength();
        if (n > 0) {
            builder.append(new DecimalFormat(fmt).format(rd.get(0)));
            for (int i = 1; i < n; ++i) {
                builder.append('\t').append(new DecimalFormat(fmt).format(rd.get(i)));
            }
        }
        return builder.toString();
    }

    public static boolean equals(IReadDataBlock l, IReadDataBlock r, double eps) {
        int nr;
        int nl = l.getLength();
        if (nl != (nr = r.getLength())) {
            return false;
        }
        for (int i = 0; i < nr; ++i) {
            if (!(Math.abs(l.get(i) - r.get(i)) > eps)) continue;
            return false;
        }
        return true;
    }
}

