/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.utilities.StringFormatter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import jd2.xml.IXmlConverter;
import jd2.xml.XmlEmptyElement;
import jd2.xml.XmlPeriodSelectionBetween;
import jd2.xml.XmlPeriodSelectionExcluding;

@XmlType(name="periodSelectionType")
public class XmlPeriodSelection
implements IXmlConverter<TsPeriodSelector> {
    static final String NAME = "periodSelectionType";
    @XmlElement
    public XmlEmptyElement all;
    @XmlElement
    public XmlEmptyElement none;
    @XmlElement
    public String from;
    @XmlElement
    public String to;
    @XmlElement
    public String first;
    @XmlElement
    public String last;
    @XmlElement
    public XmlPeriodSelectionExcluding excluding;
    @XmlElement
    public XmlPeriodSelectionBetween between;

    @Override
    public TsPeriodSelector create() {
        TsPeriodSelector tssel = new TsPeriodSelector();
        if (this.excluding != null) {
            tssel.excluding(this.excluding.nfirst, this.excluding.nlast);
        } else if (this.between != null) {
            tssel.between(StringFormatter.convertDay((String)this.between.start, (Day)Day.BEG), StringFormatter.convertDay((String)this.between.end, (Day)Day.END));
        } else if (this.from != null) {
            tssel.from(StringFormatter.convertDay((String)this.from, (Day)Day.BEG));
        } else if (this.to != null) {
            tssel.to(StringFormatter.convertDay((String)this.to, (Day)Day.BEG));
        } else if (this.all != null) {
            tssel.all();
        } else if (this.none != null) {
            tssel.none();
        } else if (this.first != null) {
            tssel.first(Integer.parseInt(this.first));
        } else if (this.last != null) {
            tssel.last(Integer.parseInt(this.last));
        }
        return tssel;
    }

    @Override
    public void copy(TsPeriodSelector t) {
        if (t.getType() == PeriodSelectorType.All) {
            this.all = new XmlEmptyElement();
        } else if (t.getType() == PeriodSelectorType.Between) {
            this.between = new XmlPeriodSelectionBetween();
            this.between.start = StringFormatter.convert((Day)t.getD0(), (Day)Day.BEG);
            this.between.end = StringFormatter.convert((Day)t.getD1(), (Day)Day.END);
        } else if (t.getType() == PeriodSelectorType.From) {
            this.from = StringFormatter.convert((Day)t.getD0(), (Day)Day.BEG);
        } else if (t.getType() == PeriodSelectorType.To) {
            this.to = StringFormatter.convert((Day)t.getD1(), (Day)Day.END);
        } else if (t.getType() == PeriodSelectorType.First) {
            this.first = Integer.toString(t.getN0());
        } else if (t.getType() == PeriodSelectorType.Last) {
            this.last = Integer.toString(t.getN1());
        } else if (t.getType() == PeriodSelectorType.Excluding) {
            this.excluding = new XmlPeriodSelectionExcluding();
            this.excluding.nfirst = t.getN0();
            this.excluding.nlast = t.getN1();
        } else {
            this.none = new XmlEmptyElement();
        }
    }
}

