/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class InterquartileRange
extends SimpleBatchFilter {
    private static final long serialVersionUID = -227879653639723030L;
    public static final int NON_NUMERIC = -1;
    protected Range m_Attributes = new Range("first-last");
    protected int[] m_AttributeIndices = null;
    protected double m_OutlierFactor = 3.0;
    protected double m_ExtremeValuesFactor = 2.0 * this.m_OutlierFactor;
    protected boolean m_ExtremeValuesAsOutliers = false;
    protected double[] m_UpperExtremeValue = null;
    protected double[] m_UpperOutlier = null;
    protected double[] m_LowerOutlier = null;
    protected double[] m_IQR = null;
    protected double[] m_Median = null;
    protected double[] m_LowerExtremeValue = null;
    protected boolean m_DetectionPerAttribute = false;
    protected int[] m_OutlierAttributePosition = null;
    protected boolean m_OutputOffsetMultiplier = false;

    public String globalInfo() {
        return "A filter for detecting outliers and extreme values based on interquartile ranges. The filter skips the class attribute.\n\nOutliers:\n  Q3 + OF*IQR < x <= Q3 + EVF*IQR\n  or\n  Q1 - EVF*IQR <= x < Q1 - OF*IQR\n\nExtreme values:\n  x > Q3 + EVF*IQR\n  or\n  x < Q1 - EVF*IQR\n\nKey:\n  Q1  = 25% quartile\n  Q3  = 75% quartile\n  IQR = Interquartile Range, difference between Q1 and Q3\n  OF  = Outlier Factor\n  EVF = Extreme Value Factor";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        vector.addElement(new Option("\tSpecifies list of columns to base outlier/extreme value detection\n\ton. If an instance is considered in at least one of those\n\tattributes an outlier/extreme value, it is tagged accordingly.\n 'first' and 'last' are valid indexes.\n\t(default none)", "R", 1, "-R <col1,col2-col4,...>"));
        vector.addElement(new Option("\tThe factor for outlier detection.\n\t(default: 3)", "O", 1, "-O <num>"));
        vector.addElement(new Option("\tThe factor for extreme values detection.\n\t(default: 2*Outlier Factor)", "E", 1, "-E <num>"));
        vector.addElement(new Option("\tTags extreme values also as outliers.\n\t(default: off)", "E-as-O", 0, "-E-as-O"));
        vector.addElement(new Option("\tGenerates Outlier/ExtremeValue pair for each numeric attribute in\n\tthe range, not just a single indicator pair for all the attributes.\n\t(default: off)", "P", 0, "-P"));
        vector.addElement(new Option("\tGenerates an additional attribute 'Offset' per Outlier/ExtremeValue\n\tpair that contains the multiplier that the value is off the median.\n\t   value = median + 'multiplier' * IQR\nNote: implicitely sets '-P'.\t(default: off)", "M", 0, "-M"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption("R", stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("first-last");
        }
        string = Utils.getOption("O", stringArray);
        if (string.length() != 0) {
            this.setOutlierFactor(Double.parseDouble(string));
        } else {
            this.setOutlierFactor(3.0);
        }
        string = Utils.getOption("E", stringArray);
        if (string.length() != 0) {
            this.setExtremeValuesFactor(Double.parseDouble(string));
        } else {
            this.setExtremeValuesFactor(2.0 * this.getOutlierFactor());
        }
        this.setExtremeValuesAsOutliers(Utils.getFlag("E-as-O", stringArray));
        this.setDetectionPerAttribute(Utils.getFlag("P", stringArray));
        this.setOutputOffsetMultiplier(Utils.getFlag("M", stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-R");
        if (!this.getAttributeIndices().equals("")) {
            vector.add(this.getAttributeIndices());
        } else {
            vector.add("first-last");
        }
        vector.add("-O");
        vector.add("" + this.getOutlierFactor());
        vector.add("-E");
        vector.add("" + this.getExtremeValuesFactor());
        if (this.getExtremeValuesAsOutliers()) {
            vector.add("-E-as-O");
        }
        if (this.getDetectionPerAttribute()) {
            vector.add("-P");
        }
        if (this.getOutputOffsetMultiplier()) {
            vector.add("-M");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on;  this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; specify an inclusive range with \"-\", eg: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Attributes.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_Attributes.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public String outlierFactorTipText() {
        return "The factor for determining the thresholds for outliers.";
    }

    public void setOutlierFactor(double d) {
        if (d >= this.getExtremeValuesFactor()) {
            System.err.println("OutlierFactor must be smaller than ExtremeValueFactor");
        } else {
            this.m_OutlierFactor = d;
        }
    }

    public double getOutlierFactor() {
        return this.m_OutlierFactor;
    }

    public String extremeValuesFactorTipText() {
        return "The factor for determining the thresholds for extreme values.";
    }

    public void setExtremeValuesFactor(double d) {
        if (d <= this.getOutlierFactor()) {
            System.err.println("ExtremeValuesFactor must be greater than OutlierFactor!");
        } else {
            this.m_ExtremeValuesFactor = d;
        }
    }

    public double getExtremeValuesFactor() {
        return this.m_ExtremeValuesFactor;
    }

    public String extremeValuesAsOutliersTipText() {
        return "Whether to tag extreme values also as outliers.";
    }

    public void setExtremeValuesAsOutliers(boolean bl) {
        this.m_ExtremeValuesAsOutliers = bl;
    }

    public boolean getExtremeValuesAsOutliers() {
        return this.m_ExtremeValuesAsOutliers;
    }

    public String detectionPerAttributeTipText() {
        return "Generates Outlier/ExtremeValue attribute pair for each numeric attribute, not just a single pair for all numeric attributes together.";
    }

    public void setDetectionPerAttribute(boolean bl) {
        this.m_DetectionPerAttribute = bl;
        if (!this.m_DetectionPerAttribute) {
            this.m_OutputOffsetMultiplier = false;
        }
    }

    public boolean getDetectionPerAttribute() {
        return this.m_DetectionPerAttribute;
    }

    public String outputOffsetMultiplierTipText() {
        return "Generates an additional attribute 'Offset' that contains the multiplier the value is off the median: value = median + 'multiplier' * IQR";
    }

    public void setOutputOffsetMultiplier(boolean bl) {
        this.m_OutputOffsetMultiplier = bl;
        if (this.m_OutputOffsetMultiplier) {
            this.m_DetectionPerAttribute = true;
        }
    }

    public boolean getOutputOffsetMultiplier() {
        return this.m_OutputOffsetMultiplier;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        int n;
        this.m_Attributes.setUpper(instances.numAttributes() - 1);
        this.m_AttributeIndices = this.m_Attributes.getSelection();
        for (n = 0; n < this.m_AttributeIndices.length; ++n) {
            if (this.m_AttributeIndices[n] == instances.classIndex()) {
                this.m_AttributeIndices[n] = -1;
                continue;
            }
            if (instances.attribute(this.m_AttributeIndices[n]).isNumeric()) continue;
            this.m_AttributeIndices[n] = -1;
        }
        FastVector fastVector = new FastVector();
        for (n = 0; n < instances.numAttributes(); ++n) {
            fastVector.addElement(instances.attribute(n));
        }
        if (!this.getDetectionPerAttribute()) {
            this.m_OutlierAttributePosition = new int[1];
            this.m_OutlierAttributePosition[0] = fastVector.size();
            FastVector fastVector2 = new FastVector();
            fastVector2.addElement("no");
            fastVector2.addElement("yes");
            fastVector.addElement(new Attribute("Outlier", fastVector2));
            fastVector2 = new FastVector();
            fastVector2.addElement("no");
            fastVector2.addElement("yes");
            fastVector.addElement(new Attribute("ExtremeValue", fastVector2));
        } else {
            this.m_OutlierAttributePosition = new int[this.m_AttributeIndices.length];
            for (n = 0; n < this.m_AttributeIndices.length; ++n) {
                if (this.m_AttributeIndices[n] == -1) continue;
                this.m_OutlierAttributePosition[n] = fastVector.size();
                FastVector fastVector3 = new FastVector();
                fastVector3.addElement("no");
                fastVector3.addElement("yes");
                fastVector.addElement(new Attribute(instances.attribute(this.m_AttributeIndices[n]).name() + "_Outlier", fastVector3));
                fastVector3 = new FastVector();
                fastVector3.addElement("no");
                fastVector3.addElement("yes");
                fastVector.addElement(new Attribute(instances.attribute(this.m_AttributeIndices[n]).name() + "_ExtremeValue", fastVector3));
                if (!this.getOutputOffsetMultiplier()) continue;
                fastVector.addElement(new Attribute(instances.attribute(this.m_AttributeIndices[n]).name() + "_Offset"));
            }
        }
        Instances instances2 = new Instances(instances.relationName(), fastVector, 0);
        instances2.setClassIndex(instances.classIndex());
        return instances2;
    }

    protected void computeThresholds(Instances instances) {
        this.m_UpperExtremeValue = new double[this.m_AttributeIndices.length];
        this.m_UpperOutlier = new double[this.m_AttributeIndices.length];
        this.m_LowerOutlier = new double[this.m_AttributeIndices.length];
        this.m_LowerExtremeValue = new double[this.m_AttributeIndices.length];
        this.m_Median = new double[this.m_AttributeIndices.length];
        this.m_IQR = new double[this.m_AttributeIndices.length];
        for (int i = 0; i < this.m_AttributeIndices.length; ++i) {
            double d;
            double d2;
            if (this.m_AttributeIndices[i] == -1) continue;
            double[] dArray = instances.attributeToDoubleArray(this.m_AttributeIndices[i]);
            int[] nArray = Utils.sort(dArray);
            int n = nArray.length / 2;
            int n2 = n / 2;
            double d3 = nArray.length % 2 == 1 ? dArray[nArray[n]] : (dArray[nArray[n]] + dArray[nArray[n + 1]]) / 2.0;
            if (n % 2 == 1) {
                d2 = dArray[nArray[n2]];
                d = dArray[nArray[nArray.length - n2 - 1]];
            } else {
                d2 = (dArray[nArray[n2]] + dArray[nArray[n2 + 1]]) / 2.0;
                d = (dArray[nArray[nArray.length - n2 - 1]] + dArray[nArray[nArray.length - n2]]) / 2.0;
            }
            this.m_Median[i] = d3;
            this.m_IQR[i] = d - d2;
            this.m_UpperExtremeValue[i] = d + this.getExtremeValuesFactor() * this.m_IQR[i];
            this.m_UpperOutlier[i] = d + this.getOutlierFactor() * this.m_IQR[i];
            this.m_LowerOutlier[i] = d2 - this.getOutlierFactor() * this.m_IQR[i];
            this.m_LowerExtremeValue[i] = d2 - this.getExtremeValuesFactor() * this.m_IQR[i];
        }
    }

    protected boolean isOutlier(Instance instance, int n) {
        double d = instance.value(this.m_AttributeIndices[n]);
        boolean bl = this.m_UpperOutlier[n] < d && d <= this.m_UpperExtremeValue[n] || this.m_LowerExtremeValue[n] <= d && d < this.m_LowerOutlier[n];
        return bl;
    }

    protected boolean isOutlier(Instance instance) {
        boolean bl = false;
        for (int i = 0; !(i >= this.m_AttributeIndices.length || this.m_AttributeIndices[i] != -1 && (bl = this.isOutlier(instance, this.m_AttributeIndices[i]))); ++i) {
        }
        return bl;
    }

    protected boolean isExtremeValue(Instance instance, int n) {
        double d = instance.value(this.m_AttributeIndices[n]);
        boolean bl = d > this.m_UpperExtremeValue[n] || d < this.m_LowerExtremeValue[n];
        return bl;
    }

    protected boolean isExtremeValue(Instance instance) {
        boolean bl = false;
        for (int i = 0; !(i >= this.m_AttributeIndices.length || this.m_AttributeIndices[i] != -1 && (bl = this.isExtremeValue(instance, this.m_AttributeIndices[i]))); ++i) {
        }
        return bl;
    }

    protected double calculateMultiplier(Instance instance, int n) {
        double d = instance.value(this.m_AttributeIndices[n]);
        double d2 = (d - this.m_Median[n]) / this.m_IQR[n];
        return d2;
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.computeThresholds(instances);
        }
        Instances instances2 = this.getOutputFormat();
        int n = instances.numAttributes();
        int n2 = instances2.numAttributes();
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance;
            Instance instance2;
            block8: {
                block7: {
                    instance2 = instances.instance(i);
                    double[] dArray = new double[n2];
                    System.arraycopy(instance2.toDoubleArray(), 0, dArray, 0, n);
                    instance = new Instance(1.0, dArray);
                    instance.setDataset(instances2);
                    if (this.getDetectionPerAttribute()) break block7;
                    if (this.isOutlier(instance2)) {
                        instance.setValue(this.m_OutlierAttributePosition[0], 1.0);
                    }
                    if (!this.isExtremeValue(instance2)) break block8;
                    instance.setValue(this.m_OutlierAttributePosition[0] + 1, 1.0);
                    if (!this.getExtremeValuesAsOutliers()) break block8;
                    instance.setValue(this.m_OutlierAttributePosition[0], 1.0);
                    break block8;
                }
                for (int j = 0; j < this.m_AttributeIndices.length; ++j) {
                    if (this.m_AttributeIndices[j] == -1) continue;
                    if (this.isOutlier(instance2, this.m_AttributeIndices[j])) {
                        instance.setValue(this.m_OutlierAttributePosition[j], 1.0);
                    }
                    if (this.isExtremeValue(instance2, this.m_AttributeIndices[j])) {
                        instance.setValue(this.m_OutlierAttributePosition[j] + 1, 1.0);
                        if (this.getExtremeValuesAsOutliers()) {
                            instance.setValue(this.m_OutlierAttributePosition[j], 1.0);
                        }
                    }
                    if (!this.getOutputOffsetMultiplier()) continue;
                    instance.setValue(this.m_OutlierAttributePosition[j] + 2, this.calculateMultiplier(instance2, this.m_AttributeIndices[j]));
                }
            }
            this.copyValues(instance, false, instance2.dataset(), this.getOutputFormat());
            instances2.add(instance);
        }
        return instances2;
    }

    public static void main(String[] stringArray) {
        InterquartileRange.runFilter(new InterquartileRange(), stringArray);
    }
}

