/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray.mut;

import net.sourceforge.jclec.realarray.UniformMutator;
import net.sourceforge.jclec.util.range.Interval;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class NonUniformMutator
extends UniformMutator {
    private static final long serialVersionUID = 6181346796048579933L;
    private double b;
    private double gmax;
    private transient double actualGeneration;
    private transient double exp;

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public int getGmax() {
        return (int)this.gmax;
    }

    public void setGmax(int gmax) {
        this.gmax = gmax;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double b = settings.getDouble("[@b]", 5.0);
        this.setB(b);
        int gmax = settings.getInt("[@g-max]", 100);
        this.setGmax(gmax);
    }

    public boolean equals(Object other) {
        if (other instanceof NonUniformMutator) {
            NonUniformMutator o = (NonUniformMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusMutProb, o.locusMutProb);
            eb.append(this.b, o.b);
            eb.append(this.gmax, o.gmax);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public void prepareMutation() {
        super.prepareMutation();
        this.actualGeneration = this.context.getGeneration();
        this.exp = Math.pow(1.0 - this.actualGeneration / this.gmax, this.b);
    }

    @Override
    protected void doLocusMutation(double[] parentChromosome, double[] mutantChromosome, int locusIndex) {
        double newValue;
        if (this.randgen.coin()) {
            double triang = parentChromosome[locusIndex] - ((Interval)this.genotypeSchema[locusIndex]).getLeft();
            newValue = parentChromosome[locusIndex] - (triang *= 1.0 - Math.pow(this.randgen.raw(), this.exp));
        } else {
            double triang = ((Interval)this.genotypeSchema[locusIndex]).getRight() - parentChromosome[locusIndex];
            newValue = parentChromosome[locusIndex] + (triang *= 1.0 - Math.pow(this.randgen.raw(), this.exp));
        }
        mutantChromosome[locusIndex] = this.genotypeSchema[locusIndex].nearestOf(newValue);
    }

    @Override
    protected double defaultLocusMutProb() {
        return 0.05;
    }
}

