/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.binarray.rec;

import net.sourceforge.jclec.binarray.BinArrayIndividual;
import net.sourceforge.jclec.binarray.BinArrayRecombinator;

public class TwoPointsCrossover
extends BinArrayRecombinator {
    private static final long serialVersionUID = 3835150645048325173L;

    public boolean equals(Object other) {
        return other instanceof TwoPointsCrossover;
    }

    @Override
    protected void recombineNext() {
        int gl = this.species.getGenotypeLength();
        BinArrayIndividual p0 = (BinArrayIndividual)this.parentsBuffer.get(this.parentsCounter);
        BinArrayIndividual p1 = (BinArrayIndividual)this.parentsBuffer.get(this.parentsCounter + 1);
        byte[] p0_genome = (byte[])p0.getGenotype();
        byte[] p1_genome = (byte[])p1.getGenotype();
        byte[] s0_genome = new byte[gl];
        byte[] s1_genome = new byte[gl];
        int cp1 = this.randgen.choose(0, gl - 1);
        int cp2 = this.randgen.choose(cp1, gl);
        System.arraycopy(p0_genome, 0, s0_genome, 0, cp1);
        System.arraycopy(p1_genome, cp1, s0_genome, cp1, cp2 - cp1);
        System.arraycopy(p0_genome, cp2, s0_genome, cp2, gl - cp2);
        System.arraycopy(p1_genome, 0, s1_genome, 0, cp1);
        System.arraycopy(p0_genome, cp1, s1_genome, cp1, cp2 - cp1);
        System.arraycopy(p1_genome, cp2, s1_genome, cp2, gl - cp2);
        this.sonsBuffer.add(this.species.createIndividual(s0_genome));
        this.sonsBuffer.add(this.species.createIndividual(s1_genome));
    }
}

