/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.nonevolutionary_algorithms.ABB_IEP;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Algorithms.Preprocess.Feature_Selection.Datos;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class ABB {
    private Datos data;
    private Parametros params;
    private boolean[] features;
    private Vector<boolean[]> pruned;
    private double threshold;

    public ABB(String ficParametros) {
        this.params = new Parametros(ficParametros);
        Randomize.setSeed(this.params.seed);
        this.data = new Datos(this.params.trainFileNameInput, this.params.testFileNameInput, this.params.paramKNN);
        this.features = new boolean[this.data.returnNumFeatures()];
        this.pruned = new Vector();
    }

    private boolean[] startSolution() {
        boolean[] fv = new boolean[Attributes.getInputNumAttributes()];
        for (int i = 0; i < fv.length; ++i) {
            fv[i] = true;
        }
        return fv;
    }

    private static int hamming(boolean[] f1, boolean[] f2) {
        int dist = 0;
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] == f2[i]) continue;
            ++dist;
        }
        return dist;
    }

    private boolean legitimate(boolean[] f) {
        boolean feas = true;
        for (int i = 0; i < this.pruned.size() && feas; ++i) {
            if (ABB.hamming(this.pruned.elementAt(i), f) != 1) continue;
            feas = false;
        }
        return feas;
    }

    private static int cardinalidadCto(boolean[] featuresVector) {
        int cardinalidad = 0;
        for (int i = 0; i < featuresVector.length; ++i) {
            if (!featuresVector[i]) continue;
            ++cardinalidad;
        }
        return cardinalidad;
    }

    private static boolean[] removeOne(boolean[] featuresVector, int which) {
        boolean[] fv = new boolean[featuresVector.length];
        System.arraycopy(featuresVector, 0, fv, 0, fv.length);
        boolean stop = false;
        int count = 0;
        for (int i = fv.length - 1; i >= 0 && !stop; --i) {
            if (!fv[i] || ++count != which) continue;
            fv[i] = false;
            stop = true;
        }
        return fv;
    }

    private void runABB() {
        boolean[] root = this.startSolution();
        System.arraycopy(root, 0, this.features, 0, root.length);
        this.abb(root);
        if (this.features == null) {
            System.err.println("ERROR: It couldn't be possible to find any solution.");
            System.exit(0);
        }
    }

    private void abb(boolean[] feat) {
        this.threshold = this.data.measureIEP(feat);
        for (int i = 0; i < ABB.cardinalidadCto(feat); ++i) {
            boolean[] child = ABB.removeOne(feat, i);
            double measure = this.data.measureIEP(child);
            if (this.legitimate(child) && measure < this.threshold) {
                if (measure < this.data.measureIEP(this.features)) {
                    System.arraycopy(child, 0, this.features, 0, child.length);
                }
                this.abb(child);
                continue;
            }
            this.pruned.add(child);
        }
    }

    public void ejecutar() {
        Date d = new Date();
        String resultado = "RESULTS generated at " + String.valueOf(d) + " \n--------------------------------------------------\n";
        resultado = resultado + "Algorithm Name: " + this.params.nameAlgorithm + "\n";
        this.runABB();
        resultado = resultado + "\nPARTITION Filename: " + this.params.trainFileNameInput + "\n---------------\n\n";
        resultado = resultado + "Features selected: \n";
        int numFeatures = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i]) continue;
            resultado = resultado + Attributes.getInputAttribute(i).getName() + " - ";
            ++numFeatures;
        }
        resultado = resultado + "\n\n" + String.valueOf(numFeatures) + " features of " + Attributes.getInputNumAttributes() + "\n\n";
        resultado = resultado + "Error in test (using train for prediction): " + String.valueOf(this.data.validacionCruzada(this.features)) + "\n";
        resultado = resultado + "Error in test (using test for prediction): " + String.valueOf(this.data.LVOTest(this.features)) + "\n";
        resultado = resultado + "---------------\n";
        System.out.println("Experiment completed successfully");
        Files.writeFile(this.params.extraFileNameOutput, resultado);
        this.data.generarFicherosSalida(this.params.trainFileNameOutput, this.params.testFileNameOutput, this.features);
    }

    private class Parametros {
        String nameAlgorithm;
        int paramKNN;
        String trainFileNameInput;
        String testFileNameInput;
        String testFileNameOutput;
        String trainFileNameOutput;
        String extraFileNameOutput;
        long seed;

        Parametros(String nombreFileParametros) {
            try {
                String fichero = Files.readFile(nombreFileParametros);
                fichero = fichero + "\n";
                fichero = fichero.replace('\r', ' ');
                StringTokenizer lineasFile = new StringTokenizer(fichero, "\n");
                int i = 0;
                while (lineasFile.hasMoreTokens()) {
                    String linea = lineasFile.nextToken();
                    ++i;
                    StringTokenizer tokens = new StringTokenizer(linea, " ,\t");
                    if (!tokens.hasMoreTokens()) continue;
                    String tok = tokens.nextToken();
                    if (tok.equalsIgnoreCase("algorithm")) {
                        this.nameAlgorithm = this.getParamString(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("inputdata")) {
                        this.getInputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("outputdata")) {
                        this.getOutputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("seed")) {
                        this.seed = this.getParamLong(tokens);
                        continue;
                    }
                    throw new IOException("Syntax error on line " + i + ": [" + tok + "]\n");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e + "Parameter file");
            }
            catch (IOException e) {
                System.err.println(e + "Aborting program");
                System.exit(-1);
            }
            String contents = "-- Parameters echo --- \n";
            contents = contents + "Algorithm name: " + this.nameAlgorithm + "\n";
            contents = contents + "Input Train File: " + this.trainFileNameInput + "\n";
            contents = contents + "Input Test File: " + this.testFileNameInput + "\n";
            contents = contents + "Output Train File: " + this.trainFileNameOutput + "\n";
            contents = contents + "Output Test File: " + this.testFileNameOutput + "\n";
            System.out.println(contents);
        }

        private double getParamFloat(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Float.parseFloat(val);
        }

        private int getParamInt(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Integer.parseInt(val);
        }

        private String getParamString(StringTokenizer s) {
            String contenido = "";
            String val = s.nextToken();
            while (s.hasMoreTokens()) {
                contenido = contenido + s.nextToken() + " ";
            }
            return contenido.trim();
        }

        private long getParamLong(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Long.parseLong(val);
        }

        private void getInputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameInput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameInput = s.nextToken().replace('\"', ' ').trim();
        }

        private void getOutputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.extraFileNameOutput = s.nextToken().replace('\"', ' ').trim();
        }
    }
}

