/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.BasicMethods;

import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class RandomSelector
extends PrototypeGenerator {
    protected int numberOfPrototypesSelected;

    public RandomSelector(PrototypeSet t, int n) {
        super(t);
        this.algorithmName = "RandomSelector";
        this.numberOfPrototypesSelected = n;
    }

    public RandomSelector(PrototypeSet t, Parameters params) {
        super(t, params);
        this.algorithmName = "RandomSelector";
    }

    @Override
    public PrototypeSet reduceSet() {
        return super.selecRandomSet(this.numberOfPrototypesSelected, false);
    }

    public static void main(String[] args) {
        Parameters.setUse("RandomSelector", "<number of prototypes>");
        Parameters.assertBasicArgs(args);
        RandomSelector.setSeed(System.nanoTime() * 100L + System.nanoTime());
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        int n = Parameters.assertExtendedArgAsInt(args, 2, "number of prototypes", 1.0, training.size() - 1);
        RandomSelector generator = new RandomSelector(training, n);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

