/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.myDataset;

public class Apriori {
    ArrayList<Itemset> L1;
    double minpsup;
    double minpconf;
    double MS;
    int nClasses;
    int nVariables;
    long time;
    RuleBase ruleBase;

    public Apriori() {
    }

    public Apriori(double minpsup, double minpconf, double MS, RuleBase ruleBase) {
        this.L1 = new ArrayList();
        this.minpsup = minpsup;
        this.minpconf = minpconf;
        this.MS = MS;
        this.ruleBase = ruleBase;
    }

    public void generate(myDataset train, int[] nLabels) {
        this.time = 0L;
        this.nClasses = train.getnClasses();
        this.nVariables = train.getnInputs();
        for (int i = 0; i < this.nClasses; ++i) {
            System.out.println("Class: " + (i + 1));
            this.generateL1(train, nLabels, i);
            this.generateLarge(this.L1, train);
            System.gc();
        }
    }

    private void generateL1(myDataset train, int[] nLabels, int clas) {
        Itemset itemset = new Itemset(clas, this.MS);
        this.L1.clear();
        for (int i = 0; i < this.nVariables; ++i) {
            for (int j = 0; j < nLabels[i]; ++j) {
                Item item = new Item(i, j);
                itemset.add(item);
                itemset.calculateSupports(train);
                if (itemset.getSupportClass() >= this.minpsup) {
                    this.L1.add(itemset.clone());
                }
                itemset.remove(0);
            }
        }
        this.generateRules(this.L1);
    }

    private void generateLarge(ArrayList<Itemset> Lk, myDataset train) {
        int size = Lk.size();
        if (size > 1 && Lk.get(0).size() < this.nVariables) {
            ArrayList<Itemset> Lnew = new ArrayList<Itemset>();
            for (int i = 0; i < size - 1; ++i) {
                Itemset itemseti = Lk.get(i);
                for (int j = i + 1; j < size; ++j) {
                    Itemset itemsetj = Lk.get(j);
                    if (!this.isCombinable(itemseti, itemsetj)) continue;
                    Itemset newItemset = itemseti.clone();
                    newItemset.add(itemsetj.get(itemsetj.size() - 1).clone());
                    newItemset.calculateSupports(train);
                    if (!(newItemset.getSupportClass() >= this.minpsup)) continue;
                    Lnew.add(newItemset);
                }
                this.generateLarge(Lnew, train);
                this.generateRules(Lnew);
                Lnew.clear();
            }
            System.gc();
        }
    }

    private boolean isCombinable(Itemset itemseti, Itemset itemsetj) {
        Item itemi = itemseti.get(itemseti.size() - 1);
        Item itemj = itemsetj.get(itemseti.size() - 1);
        return itemi.getVariable() < itemj.getVariable();
    }

    private void generateRules(ArrayList<Itemset> Lk) {
        Itemset itemset;
        for (int i = 0; i < Lk.size(); ++i) {
            itemset = Lk.get(i);
            double confidence = itemset.getSupportClass() / itemset.getSupport();
            if (!(confidence >= this.minpconf)) continue;
            this.ruleBase.add(itemset, this.time);
            ++this.time;
        }
        if (this.ruleBase.size() > 200000) {
            this.ruleBase.selection();
            itemset = Lk.get(0);
            System.out.println("Number of rules in Apriori (" + itemset.getClas() + "/" + this.nClasses + "): " + this.ruleBase.size());
            System.gc();
        }
    }
}

