/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.rng.Rijndael_Algorithm;

public class RandRijndael
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final int BLOCK_SIZE = 16;
    private static final int JUMP_STREAM = 10;
    private static final int JUMP_SUBSTREAM = 5;
    private static Object key;
    private static byte[] curr_stream;
    private byte[] stream = new byte[16];
    private byte[] substream = new byte[16];
    private byte[] state = new byte[16];
    private byte[] output;
    private int outputPos;

    private static void iterate(byte[] b, int pos) {
        while (pos < b.length) {
            int n = pos++;
            b[n] = (byte)(b[n] + 1);
            if (b[n] == 0) continue;
        }
    }

    public RandRijndael() {
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = curr_stream[i];
        }
        RandRijndael.iterate(curr_stream, 10);
        this.resetStartStream();
    }

    public RandRijndael(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(byte[] seed) {
        if (seed.length != 16) {
            throw new IllegalArgumentException("Seed must contain 16 values");
        }
        for (int i = 0; i < 16; ++i) {
            RandRijndael.curr_stream[i] = seed[i];
        }
    }

    public void setSeed(byte[] seed) {
        if (seed.length != 16) {
            throw new IllegalArgumentException("Seed must contain 16 values");
        }
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = seed[i];
        }
    }

    public byte[] getState() {
        byte[] stateCopy = new byte[16];
        for (int i = 0; i < 16; ++i) {
            stateCopy[i] = this.state[i];
        }
        return stateCopy;
    }

    public RandRijndael clone() {
        int i;
        RandRijndael retour = null;
        retour = (RandRijndael)super.clone();
        retour.stream = new byte[16];
        retour.substream = new byte[16];
        retour.state = new byte[16];
        retour.output = new byte[this.output.length];
        for (i = 0; i < 16; ++i) {
            retour.stream[i] = this.stream[i];
            retour.substream[i] = this.substream[i];
            retour.state[i] = this.state[i];
        }
        for (i = 0; i < this.output.length; ++i) {
            retour.output[i] = this.output[i];
        }
        return retour;
    }

    public void resetStartStream() {
        for (int i = 0; i < 16; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        for (int i = 0; i < 16; ++i) {
            this.state[i] = this.substream[i];
        }
        this.nextOutput();
    }

    public void resetNextSubstream() {
        RandRijndael.iterate(this.substream, 5);
        this.resetStartSubstream();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name == null) {
            sb.append("The state of the RandRijn is : [");
        } else {
            sb.append("The state of the " + this.name + " is : [");
        }
        for (int i = 0; i < 15; ++i) {
            sb.append(this.state[i] + ", ");
        }
        sb.append(this.state[15] + "]  ");
        sb.append("position : " + this.outputPos);
        return sb.toString();
    }

    private void nextOutput() {
        this.output = Rijndael_Algorithm.blockEncrypt(this.state, 0, key, 16);
        this.outputPos = 0;
        RandRijndael.iterate(this.state, 0);
    }

    protected double nextValue() {
        if (this.outputPos > 12) {
            this.nextOutput();
        }
        long val = this.output[this.outputPos++] & 0xFF;
        val <<= 8;
        val |= (long)(this.output[this.outputPos++] & 0xFF);
        val <<= 8;
        val |= (long)(this.output[this.outputPos++] & 0xFF);
        val <<= 8;
        return ((double)(val |= (long)(this.output[this.outputPos++] & 0xFF)) + 1.0) / 4.294967297E9;
    }

    static {
        try {
            key = Rijndael_Algorithm.makeKey(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, 16);
        }
        catch (Exception e) {
            key = new Object[0];
            e.printStackTrace();
            throw new RuntimeException("  cannot create RandRijndael key");
        }
        curr_stream = new byte[16];
        for (int i = 0; i < 16; ++i) {
            RandRijndael.curr_stream[i] = 0;
        }
    }
}

