/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveGraph;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.solver.constraints.global.scheduling.precedence.ITemporalSRelation;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TObjectProcedure;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;

public class DisjunctiveSModel
extends DisjunctiveGraph<ITemporalSRelation> {
    private ITemporalSRelation[] constraints;
    public final Solver solver;
    private int idx = 0;

    public DisjunctiveSModel(PreProcessCPSolver solver) {
        this(solver, solver.getDisjModel());
    }

    public DisjunctiveSModel(Solver solver, DisjunctiveModel dmod) {
        super(solver.getNbTaskVars());
        this.solver = solver;
        if (solver.getModel() != dmod.getModel()) {
            throw new SolverException("cant build disjunctive model");
        }
        TIntIntHashMap hookToIndexM = new TIntIntHashMap(this.nbNodes);
        Iterator<MultipleVariables> iter = solver.getModel().getMultipleVarIterator();
        while (iter.hasNext()) {
            MultipleVariables mv = iter.next();
            if (!(mv instanceof TaskVariable)) continue;
            TaskVariable tv = (TaskVariable)mv;
            TaskVar t = solver.getVar(tv);
            hookToIndexM.put(tv.getHook(), t.getID());
        }
        for (int i = 0; i < dmod.nbNodes; ++i) {
            int d;
            int o = hookToIndexM.get(i);
            int j = dmod.precGraph[i].nextSetBit(0);
            while (j >= 0) {
                d = hookToIndexM.get(j);
                if (dmod.containsConstraint(i, j)) {
                    this.addArc(o, d, dmod.setupTime(i, j));
                }
                j = dmod.precGraph[i].nextSetBit(j + 1);
            }
            j = dmod.disjGraph[i].nextSetBit(0);
            while (j >= 0) {
                if (dmod.containsConstraint(i, j)) {
                    d = hookToIndexM.get(j);
                    ITemporalSRelation rel = (ITemporalSRelation)((Object)solver.getCstr((Constraint)dmod.getConstraint(i, j)));
                    this.addEdge(o, d, dmod.setupTime(i, j), dmod.setupTime(j, i), rel);
                }
                j = dmod.disjGraph[i].nextSetBit(j + 1);
            }
        }
    }

    public final Solver getSolver() {
        return this.solver;
    }

    public final boolean containsEdge(ITask t1, ITask t2) {
        return this.containsEdge(t1.getID(), t2.getID());
    }

    public final ITemporalSRelation getConstraint(ITask t1, ITask t2) {
        return (ITemporalSRelation)this.getConstraint(t1.getID(), t2.getID());
    }

    public final IntDomainVar[] getDisjuncts() {
        final IntDomainVar[] disjuncts = new IntDomainVar[this.getNbEdges()];
        this.idx = 0;
        this.storedConstraints.forEachValue(new TObjectProcedure<ITemporalSRelation>(){

            @Override
            public boolean execute(ITemporalSRelation arg0) {
                if (!arg0.isFixed()) {
                    disjuncts[((DisjunctiveSModel)DisjunctiveSModel.this).idx++] = (IntDomainVar)arg0.getDirection();
                }
                return true;
            }
        });
        return this.idx == disjuncts.length ? disjuncts : Arrays.copyOf(disjuncts, this.idx);
    }

    public final ITemporalSRelation[] getEdges() {
        int n = this.getNbEdges();
        this.constraints = new ITemporalSRelation[n];
        this.idx = 0;
        this.storedConstraints.forEachValue(new TObjectProcedure<ITemporalSRelation>(){

            @Override
            public boolean execute(ITemporalSRelation arg0) {
                if (!arg0.isFixed()) {
                    ((DisjunctiveSModel)DisjunctiveSModel.this).constraints[((DisjunctiveSModel)DisjunctiveSModel.this).idx++] = arg0;
                }
                return true;
            }
        });
        return this.idx == this.constraints.length ? this.constraints : Arrays.copyOf(this.constraints, this.idx);
    }

    public final BitSet[] generatePrecGraph() {
        BitSet[] graph = this.copyPrecGraph();
        for (int i = 0; i < this.nbNodes; ++i) {
            int j = this.disjGraph[i].nextSetBit(0);
            while (j >= 0) {
                if (this.containsRelation(i, j)) {
                    int d;
                    int o;
                    ITemporalSRelation rel = (ITemporalSRelation)this.getConstraint(i, j);
                    if (rel == null) {
                        rel = (ITemporalSRelation)this.getConstraint(j, i);
                        o = j;
                        d = i;
                    } else {
                        o = i;
                        d = j;
                    }
                    if (rel.isFixed()) {
                        if (rel.getDirVal() == 0) {
                            graph[d].set(o);
                        } else {
                            assert (rel.getDirVal() == 1);
                            graph[o].set(d);
                        }
                    }
                }
                j = this.disjGraph[i].nextSetBit(j + 1);
            }
        }
        return graph;
    }

    public static final TIntArrayList[] convertToLists(BitSet[] graph) {
        TIntArrayList[] res = new TIntArrayList[graph.length];
        for (int i = 0; i < graph.length; ++i) {
            res[i] = new TIntArrayList(graph[i].cardinality());
            int j = graph[i].nextSetBit(0);
            while (j >= 0) {
                res[i].add(j);
                j = graph[i].nextSetBit(j + 1);
            }
        }
        return res;
    }

    public final TIntArrayList[] generatePrecReductionGraph() {
        BitSet[] graph = this.generatePrecGraph();
        DisjunctiveSModel.floydMarshallClosure(graph);
        DisjunctiveSModel.floydMarshallReduction(graph);
        return DisjunctiveSModel.convertToLists(graph);
    }

    @Override
    protected StringBuilder toDottyNodes() {
        StringBuilder b = new StringBuilder();
        DisposableIterator<TaskVar> iter = this.solver.getTaskVarIterator();
        while (iter.hasNext()) {
            b.append(((TaskVar)iter.next()).toDotty()).append('\n');
        }
        iter.dispose();
        return b;
    }
}

