/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import com.eaio.util.lang.Hex;
import com.eaio.uuid.MACAddressParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class UUIDGen {
    private static long lastTime;
    private static long clockSeqAndNode;
    private static String macAddress;

    private UUIDGen() {
    }

    public static String getMacAddress() {
        return macAddress;
    }

    public static long getClockSeqAndNode() {
        return clockSeqAndNode;
    }

    public static synchronized long newTime() {
        long l = System.currentTimeMillis() * 10000L + 122192928000000000L;
        if (l > lastTime) {
            lastTime = l;
        } else {
            l = ++lastTime;
        }
        long l2 = l << 32;
        l2 |= (l & 0xFFFF00000000L) >> 16;
        return l2 |= 0x1000L | l >> 48 & 0xFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFirstLineOfCommand(String[] stringArray) throws IOException {
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
            String string = bufferedReader.readLine();
            return string;
        }
        finally {
            if (process != null) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {}
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        lastTime = Long.MIN_VALUE;
        clockSeqAndNode = Long.MIN_VALUE;
        macAddress = null;
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            object = System.getProperty("os.name");
            if (((String)object).startsWith("Windows")) {
                process = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
            } else if (((String)object).startsWith("Solaris") || ((String)object).startsWith("SunOS")) {
                string = UUIDGen.getFirstLineOfCommand(new String[]{"uname", "-n"});
                if (string != null) {
                    process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", string}, null);
                }
            } else if (new File("/usr/sbin/lanscan").exists()) {
                process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
            } else if (new File("/sbin/ifconfig").exists()) {
                process = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
            }
            if (process != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
                string = null;
                while ((string = bufferedReader.readLine()) != null && ((macAddress = MACAddressParser.parse(string)) == null || Hex.parseShort(macAddress) == 255)) {
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (process != null) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {}
                process.destroy();
            }
        }
        if (macAddress != null) {
            if (macAddress.indexOf(58) != -1) {
                clockSeqAndNode |= Hex.parseLong(macAddress);
            } else if (macAddress.startsWith("0x")) {
                clockSeqAndNode |= Hex.parseLong(macAddress.substring(2));
            }
        } else {
            try {
                object = InetAddress.getLocalHost().getAddress();
                clockSeqAndNode |= (long)(object[0] << 24) & 0xFF000000L;
                clockSeqAndNode |= (long)(object[1] << 16 & 0xFF0000);
                clockSeqAndNode |= (long)(object[2] << 8 & 0xFF00);
                clockSeqAndNode |= (long)(object[3] & 0xFF);
            }
            catch (UnknownHostException unknownHostException) {
                clockSeqAndNode |= (long)(Math.random() * 2.147483647E9);
            }
        }
        clockSeqAndNode |= (long)(Math.random() * 16383.0) << 48;
    }
}

