/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVectorUtil;
import org.jpmml.rexp.TransformerEncoder;

public class RecipeEncoder
extends TransformerEncoder<RGenericVector> {
    private Map<String, Role> varRoles = Collections.emptyMap();
    private Map<String, Source> varSources = Collections.emptyMap();
    private Map<String, Type> varTypes = Collections.emptyMap();
    private Map<String, Role> termRoles = Collections.emptyMap();
    private Map<String, Source> termSources = Collections.emptyMap();
    private Map<String, Type> termTypes = Collections.emptyMap();

    public RecipeEncoder(RGenericVector recipe) {
        super(recipe);
        RGenericVector varInfo = recipe.getGenericElement("var_info");
        RGenericVector termInfo = recipe.getGenericElement("term_info");
        this.varRoles = RecipeEncoder.parseInfo(varInfo, "role", value -> Role.valueOf(value.toUpperCase()));
        this.varSources = RecipeEncoder.parseInfo(varInfo, "source", value -> Source.valueOf(value.toUpperCase()));
        this.varTypes = RecipeEncoder.parseInfo(varInfo, "type", value -> Type.valueOf(value.toUpperCase()));
        this.termRoles = RecipeEncoder.parseInfo(termInfo, "role", value -> Role.valueOf(value.toUpperCase()));
        this.termSources = RecipeEncoder.parseInfo(termInfo, "source", value -> Source.valueOf(value.toUpperCase()));
        this.termTypes = RecipeEncoder.parseInfo(termInfo, "type", value -> Type.valueOf(value.toUpperCase()));
    }

    @Override
    public Schema createSchema() {
        RGenericVector recipe = (RGenericVector)this.getObject();
        Label label = this.getLabel();
        List<Feature> features = this.getFeatures();
        RGenericVector steps = recipe.getGenericElement("steps");
        List outcomeNames = this.termRoles.entrySet().stream().filter(entry -> entry.getValue() == Role.OUTCOME).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (outcomeNames.size() == 1) {
            ScalarLabel scalarLabel = (ScalarLabel)label;
            String outcomeName = (String)outcomeNames.get(0);
            this.renameDataField(scalarLabel.getName(), outcomeName);
            label = scalarLabel.toRenamedLabel(outcomeName);
        } else if (outcomeNames.size() >= 2) {
            throw new IllegalArgumentException();
        }
        if (steps != null) {
            throw new IllegalArgumentException();
        }
        return new Schema((PMMLEncoder)this, label, features);
    }

    private void renameDataField(String name, String renamedName) {
        DataField dataField = this.removeDataField(name);
        dataField.setName(renamedName);
        this.addDataField(dataField);
    }

    private static <E extends Enum<E>> Map<String, E> parseInfo(RGenericVector info, String name, Function<String, E> function) {
        RStringVector variable = info.getStringElement("variable");
        RStringVector value = info.getStringElement(name);
        RVectorUtil.checkSize(variable, value);
        LinkedHashMap<String, E> result = new LinkedHashMap<String, E>();
        for (int i = 0; i < variable.size(); ++i) {
            result.put(variable.getValue(i), function.apply(value.getValue(i)));
        }
        return result;
    }

    private static enum Type {
        LOGICAL,
        NOMINAL,
        NUMERIC;

    }

    private static enum Source {
        ORIGINAL,
        DERIVED;

    }

    private static enum Role {
        OUTCOME,
        PREDICTOR;

    }
}

