/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.regression.PMMLAttributes;
import org.dmg.pmml.regression.Term;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="NumericPredictor", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="NumericPredictor")
@JsonPropertyOrder(value={"field", "exponent", "coefficient", "extensions"})
public class NumericPredictor
extends Term
implements HasExtensions<NumericPredictor>,
HasFieldReference<NumericPredictor> {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="name")
    private String field;
    @XmlAttribute(name="exponent")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="exponent")
    private Integer exponent;
    @XmlAttribute(name="coefficient", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="coefficient")
    private Number coefficient;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final Integer DEFAULT_EXPONENT = new IntegerAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371270L;

    public NumericPredictor() {
    }

    @ValueConstructor
    public NumericPredictor(@Property(value="field") String field, @Property(value="coefficient") Number coefficient) {
        this.field = field;
        this.coefficient = coefficient;
    }

    @AlternateValueConstructor
    public NumericPredictor(Field<?> field, Number coefficient) {
        this(field != null ? field.getName() : null, coefficient);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NUMERICPREDICTOR_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public NumericPredictor setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    public Integer getExponent() {
        if (this.exponent == null) {
            return DEFAULT_EXPONENT;
        }
        return this.exponent;
    }

    public NumericPredictor setExponent(@Property(value="exponent") Integer exponent) {
        this.exponent = exponent;
        return this;
    }

    @Override
    public Number requireCoefficient() {
        if (this.coefficient == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NUMERICPREDICTOR_COEFFICIENT);
        }
        return this.coefficient;
    }

    @Override
    public Number getCoefficient() {
        return this.coefficient;
    }

    @Override
    public NumericPredictor setCoefficient(@Property(value="coefficient") Number coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NumericPredictor addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

