/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropXltCReif
extends Propagator<IntVar> {
    IntVar var;
    int cste;
    BoolVar r;

    public PropXltCReif(IntVar x, int c, BoolVar r) {
        super((Variable[])new IntVar[]{x, r}, (Priority)PropagatorPriority.BINARY, false, true);
        this.cste = c;
        this.var = x;
        this.r = r;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.r.getLB() == 1) {
            this.var.updateUpperBound(this.cste - 1, this);
            this.setPassive();
        } else if (this.r.getUB() == 0) {
            this.var.updateLowerBound(this.cste, this);
            this.setPassive();
        } else if (this.var.getUB() < this.cste) {
            this.r.setToTrue(this);
            this.setPassive();
        } else if (this.var.getLB() >= this.cste) {
            this.r.setToFalse(this);
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.r.isInstantiatedTo(1)) {
                return ESat.eval(this.var.getUB() < this.cste);
            }
            return ESat.eval(this.var.getLB() >= this.cste);
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        if (((IntVar[])this.vars)[1].isInstantiatedTo(1)) {
            if (pivot == ((IntVar[])this.vars)[1]) {
                ((IntVar[])this.vars)[1].intersectLit(1, explanation);
                IntIterableRangeSet dom0 = explanation.complement(((IntVar[])this.vars)[0]);
                dom0.retainBetween(this.cste, 0x3FFFFFFF);
                ((IntVar[])this.vars)[0].unionLit(dom0, explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                ((IntVar[])this.vars)[1].unionLit(0, explanation);
                ((IntVar[])this.vars)[0].intersectLit(-1073741823, this.cste - 1, explanation);
            }
        } else if (((IntVar[])this.vars)[1].isInstantiatedTo(0)) {
            if (pivot == ((IntVar[])this.vars)[1]) {
                ((IntVar[])this.vars)[1].intersectLit(0, explanation);
                IntIterableRangeSet dom0 = explanation.complement(((IntVar[])this.vars)[0]);
                dom0.retainBetween(-1073741823, this.cste - 1);
                ((IntVar[])this.vars)[0].unionLit(dom0, explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                ((IntVar[])this.vars)[1].unionLit(1, explanation);
                ((IntVar[])this.vars)[0].intersectLit(this.cste, 0x3FFFFFFF, explanation);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public String toString() {
        return "(" + this.var.getName() + " < " + this.cste + ") <=> " + this.r.getName();
    }
}

