/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.dynamic;

import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.setDataStructures.AbstractSet;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class SetUnion
extends AbstractSet {
    public ISet[] sets;
    protected ISet values;

    public SetUnion(ISet ... sets) {
        this(SetType.RANGESET, 0, sets);
    }

    public SetUnion(SetType setType, int offset, ISet ... sets) {
        this.sets = sets;
        this.values = SetFactory.makeSet(setType, offset);
        this.init();
    }

    public SetUnion(Model model, ISet ... sets) {
        this(model, SetType.RANGESET, 0, sets);
    }

    public SetUnion(Model model, SetType setType, int offset, ISet ... sets) {
        this.sets = sets;
        this.values = SetFactory.makeStoredSet(setType, offset, model);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].registerObserver(this, i);
            ISetIterator iSetIterator = this.sets[i].iterator();
            while (iSetIterator.hasNext()) {
                int v = (Integer)iSetIterator.next();
                this.values.add(v);
            }
        }
    }

    @Override
    public ISetIterator iterator() {
        return this.values.iterator();
    }

    @Override
    public ISetIterator newIterator() {
        return this.values.newIterator();
    }

    @Override
    public boolean add(int element) {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public boolean remove(int element) {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public boolean contains(int element) {
        return this.values.contains(element);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public int min() {
        return this.values.min();
    }

    @Override
    public int max() {
        return this.values.max();
    }

    @Override
    public SetType getSetType() {
        return SetType.DYNAMIC;
    }

    @Override
    public void notifyElementRemoved(int element, int idx) {
        boolean remove = true;
        for (int i = 0; i < this.sets.length; ++i) {
            if (i == idx || !this.sets[i].contains(element)) continue;
            remove = false;
            break;
        }
        if (remove) {
            this.values.remove(element);
            this.notifyObservingElementRemoved(element);
        }
    }

    @Override
    public void notifyElementAdded(int element, int idx) {
        if (this.values.add(element)) {
            this.notifyObservingElementAdded(element);
        }
    }

    @Override
    public void notifyCleared(int idx) {
        ISetIterator iSetIterator = this.values.iterator();
        while (iSetIterator.hasNext()) {
            int element = (Integer)iSetIterator.next();
            boolean remove = true;
            for (ISet set : this.sets) {
                if (!set.contains(element)) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            this.values.remove(element);
            this.notifyObservingElementRemoved(element);
        }
    }
}

