/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.meta.DiscRanges;
import dmLab.array.saver.Array2File;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.ComplexSet;
import dmLab.classifier.adx.ruleFamily.RuleFamily;
import dmLab.classifier.adx.ruleSet.RuleSet;
import dmLab.classifier.adx.selector.Selector;
import dmLab.classifier.attributeIndicators.ADXSelectorIndicators;
import dmLab.classifier.attributeIndicators.AttributeIndicators;
import dmLab.discretizer.DiscretizerParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;

public final class ADXClassifier
extends Classifier {
    private ADXParams cfg;
    private FArray trainArray;
    private RuleFamily ruleFamily;
    private DiscretizerParams discParams;
    private DiscRanges[] discRangesTrain;

    public ADXClassifier() {
        this.label = labels[ADX];
        this.model = ADX;
        this.params = new ADXParams();
        this.cfg = (ADXParams)this.params;
        this.discParams = new DiscretizerParams();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean train(FArray trainArray) {
        block9: {
            block10: {
                if (!this.checkTargetAttr(trainArray)) {
                    return false;
                }
                this.trainArray = trainArray;
                var7_2 = trainArray;
                this.ruleFamily = new RuleFamily(trainArray.getDecValues().length, var7_2.attributes.length, this.cfg);
                this.ruleFamily.verbose = this.cfg.verbose;
                start = System.currentTimeMillis();
                var5_5 = trainArray;
                var4_6 = this;
                if (var5_5.isDiscretized()) break block10;
                System.out.println("Warning! Input table contains numeric values. Discretization is processed...");
                var4_6.discParams.verbose = var4_6.cfg.verbose;
                var6_9 = var4_6.discParams;
                var5_5 = var4_6.trainArray;
                var7_2 = var6_9;
                if (var7_2.discIntervals <= 0) ** GOTO lbl-1000
                var7_2 = var6_9;
                if (var7_2.discAlgorithm <= 0) lbl-1000:
                // 2 sources

                {
                    v0 = false;
                } else {
                    var7_2 = var5_5;
                    var7_3 = var7_2.attributes.length;
                    var8_10 = var5_5.getDecAttrIdx();
                    var5_5.discRanges = new DiscRanges[var5_5.attributes.length];
                    var9_11 = 0;
                    while (var9_11 < var7_3) {
                        if (var5_5.attributes[var9_11].type == 2) {
                            var10_12 = var5_5.getColumn(var9_11);
                            var11_13 = var5_5.getColumn(var8_10);
                            var5_5.discRanges[var9_11] = new DiscRanges();
                            if (var5_5.discRanges[var9_11].find(var10_12, var11_13, var6_9) && var6_9.verbose) {
                                System.out.println("Attribute Discretized: " + var5_5.attributes[var9_11].name + " ranges: " + Arrays.toString(var5_5.discRanges[var9_11].getRanges()));
                            }
                        }
                        ++var9_11;
                    }
                    v0 = true;
                }
                DiscFunctions.applyRanges(var4_6.trainArray);
                v1 = true;
                break block9;
            }
            var4_7 = 0;
            if (true) ** GOTO lbl49
            do {
                if (var5_5.attributes[var4_7].type == 2 && !var5_5.isDiscretized(var4_7)) {
                    System.err.println("Error! Input table contains numeric values that are not discretized.");
                    v1 = false;
                    break block9;
                }
                ++var4_7;
lbl49:
                // 2 sources

                var7_2 = var5_5;
            } while (var4_7 < var7_2.attributes.length);
            v1 = true;
        }
        if (!v1) {
            return false;
        }
        this.storeDiscranges(trainArray.discRanges);
        trainArray.findADXDomains();
        this.ruleFamily.createRules(trainArray);
        stop = System.currentTimeMillis();
        this.learningTime = (float)(stop - var2_4) / 1000.0f;
        this.trainSetSize = var1_1.rowsNumber();
        return true;
    }

    private boolean storeDiscranges(DiscRanges[] discRanges) {
        this.discRangesTrain = (DiscRanges[])discRanges.clone();
        int i = 0;
        while (i < this.discRangesTrain.length) {
            if (this.trainArray.discRanges[i] != null) {
                this.discRangesTrain = (DiscRanges[])discRanges.clone();
            }
            ++i;
        }
        return true;
    }

    @Override
    public final boolean init() {
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_5;
        boolean bl;
        block7: {
            block9: {
                FArray fArray;
                int n;
                FArray fArray2;
                block8: {
                    block6: {
                        if (!this.checkTargetAttr(testArray)) {
                            return false;
                        }
                        fArray2 = testArray;
                        ADXClassifier aDXClassifier = this;
                        if (fArray2.isDiscretized()) break block6;
                        System.out.println("Warning! Input table contains numeric values. Discretization is applied...");
                        fArray2.discRanges = aDXClassifier.discRangesTrain;
                        DiscFunctions.applyRanges(fArray2);
                        bl = true;
                        break block7;
                    }
                    n = 0;
                    if (!true) break block8;
                    fArray = fArray2;
                    if (n >= fArray.attributes.length) break block9;
                }
                do {
                    if (fArray2.attributes[n].type == 2 && !fArray2.isDiscretized(n)) {
                        System.err.println("Error! Input table contains numeric values that are not discretized.");
                        return false;
                    }
                    ++n;
                    fArray = fArray2;
                } while (n < fArray.attributes.length);
            }
            bl = true;
        }
        if (!bl) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.predResult.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), testArray.getDecValuesStr());
        int testEventsNumber = testArray.rowsNumber();
        this.predResult.predictions = new Prediction[testEventsNumber];
        int decAttrIndex = testArray.getDecAttrIdx();
        this.ruleFamily.prepareClassification();
        int i = 0;
        while (i < testEventsNumber) {
            float predictedDecision = this.ruleFamily.classifyEvent2(testArray, i);
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.predResult.confusionMatrix.add(realDecision, predictedDecision);
            String realClassName = testArray.dictionary.toString(realDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predResult.predictions[i] = new Prediction(realClassName, predictedClassName, this.ruleFamily.getLastScores());
            ++i;
        }
        long stop = System.currentTimeMillis();
        this.testingTime = (float)(stop - var2_5) / 1000.0f;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(" ### ADX Classifier ### \n");
        tmp.append("label=" + this.label).append('\n');
        tmp.append(this.ruleFamily.toString()).append('\n');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) {
        void var2_2;
        void var1_1;
        block5: {
            FArray fArray;
            Array2File array2File = new Array2File();
            array2File.setFormat(0);
            ((Array2File)((Object)fArray)).saveFile(this.trainArray, String.valueOf(path) + "//" + name);
            String string = String.valueOf(path) + "//" + name;
            fArray = this.trainArray;
            Object object = DiscFunctions.getFileExtension(string);
            if (!((String)object).equalsIgnoreCase("dsc")) {
                string = String.valueOf(string) + ".dsc";
            }
            try {
                object = new FileWriter(string, false);
            }
            catch (IOException iOException) {
                System.err.println("Error opening file. File: ".concat(String.valueOf(string)));
                break block5;
            }
            try {
                ((Writer)object).write(DiscFunctions.toStringRanges(fArray));
                ((OutputStreamWriter)object).close();
            }
            catch (IOException iOException) {
                System.err.println("Error writing file. File: ".concat(String.valueOf(string)));
                iOException.printStackTrace();
            }
        }
        this.params.save(path, name);
        this.ruleFamily.saveSymbolicSelectors(String.valueOf(path) + "//" + name);
        this.ruleFamily.saveSelectors(String.valueOf(path) + "//" + name);
        this.ruleFamily.saveRuleFamily(String.valueOf(var1_1) + "//" + (String)var2_2);
        return false;
    }

    @Override
    public final boolean add_RI(AttributesRI[] importances) {
        this.attrSet = new HashSet();
        ADXSelectorIndicators selectorIndicators = new ADXSelectorIndicators();
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = QualityMeasure.calcWAcc(this.predResult.confusionMatrix.getMatrix());
        int rulesets = this.ruleFamily.ruleSets();
        int f = 0;
        while (f < rulesets) {
            RuleSet ruleset = this.ruleFamily.getRuleSet(f);
            int r = 0;
            while (r < ruleset.complexSetArray.length) {
                ComplexSet complexList = ruleset.complexSetArray[r];
                if (complexList != null) {
                    int complexesListSize = complexList.size();
                    int c = 0;
                    while (c < complexesListSize) {
                        Complex complex;
                        Cloneable cloneable = complex = complexList.getComplex(c);
                        ADXSelectorIndicators aDXSelectorIndicators = selectorIndicators;
                        selectorIndicators.complexPosCoverage = cloneable.posCoverage;
                        aDXSelectorIndicators.complexNegCoverage = cloneable.negCoverage;
                        aDXSelectorIndicators.complexCoverage = cloneable.coverage;
                        int complexSize = complex.size();
                        int s = 0;
                        while (s < complexSize) {
                            Selector selector = this.ruleFamily.selectorListArray[f].getSelector(complex.getSelectorId(s));
                            cloneable = selector;
                            aDXSelectorIndicators = selectorIndicators;
                            selectorIndicators.posCoverage = ((Selector)cloneable).posCoverage;
                            aDXSelectorIndicators.negCoverage = ((Selector)cloneable).negCoverage;
                            aDXSelectorIndicators.coverage = ((Selector)cloneable).coverage;
                            String attrName = this.trainArray.attributes[selector.attrIndex].name;
                            importances[0].addImportances(attrName, experimentIndicators, (AttributeIndicators)selectorIndicators);
                            importances[f + 1].addImportances(attrName, experimentIndicators, (AttributeIndicators)selectorIndicators);
                            this.attrSet.add(attrName);
                            ++s;
                        }
                        ++c;
                    }
                }
                ++r;
            }
            ++f;
        }
        int i = 0;
        while (i < importances.length) {
            importances[i].flushMeasures();
            ++i;
        }
        return true;
    }

    @Override
    public final boolean finish() {
        return true;
    }
}

