/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multitarget.functions;

import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiTargetRegressor;
import moa.core.Measurement;

public class MultiTargetNoChange
extends AbstractMultiLabelLearner
implements MultiTargetRegressor {
    private static final long serialVersionUID = 1L;
    Prediction lastSeenClasses;

    @Override
    public String getPurposeString() {
        return "Weather Forecast class classifier: always predicts the last class seen.";
    }

    @Override
    public void resetLearningImpl() {
        this.lastSeenClasses = null;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance inst) {
        int numOutputs = inst.numberOutputTargets();
        MultiLabelPrediction prediction = new MultiLabelPrediction(numOutputs);
        for (int i = 0; i < numOutputs; ++i) {
            prediction.setVotes(i, new double[]{inst.classValue(i)});
        }
        this.lastSeenClasses = prediction;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        return this.lastSeenClasses != null ? this.lastSeenClasses : null;
    }
}

