% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImageAnalyser.R
\name{getRoughnessParameters}
\alias{getRoughnessParameters}
\alias{getRoughnessParameters,AFMImage-method}
\title{Get Roughness parameters}
\usage{
getRoughnessParameters(AFMImage)

\S4method{getRoughnessParameters}{AFMImage}(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
a data.table of roughness parameters: 
\itemize{
  \item totalRMSRoughness_TotalRrms the total RMS Roughness as the square root of the variance of heights
  \item MeanRoughness_Ra the average roughness as the mean of absolute value of heights
}
}
\description{
Get basic roughness parameters as amplitude parameters:
Total root mean square Roughness or Total Rrms or totalRMSRoughness_TotalRrms\cr
Mean roughness or Ra or MeanRoughness_Ra
}
\details{
\code{getRoughnessParameters} returns a data.table of roughness parameters
}
\examples{
\dontrun{
library(AFM)

data(AFMImageOfAluminiumInterface)
roughnessParameters<-getRoughnessParameters(AFMImageOfAluminiumInterface)
print(roughnessParameters)
}

}
\author{
M.Beauvais
}
